package gov.va.med.ccht.model.dmp;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.ui.model.TermType;

public class DMPStandLibEntry extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = -7538888471186760243L;
	private DMPStandLibCatType slCategoryType;
	private transient TermType slCategoryTermType;
	private DMPStandLibContentType slContentType;
	private transient TermType slContentTermType; 
	private String slContent;
	private Boolean clinicalEvidenceVA;
/*	private DMPStandLibClinicalGuidanceType clinicalGuidanceType;
	private transient TermType clinicalGuidanceTermType;
*/	
	private Boolean clinicalEvidenceAhrq;
	private Boolean clinicalEvidenceOther;
	private String ceOtherText;
	private String rsnModComment;
	private DMPStandLibRsnModType reasonModType;
	private transient TermType reasonModTermType;
	private transient String clinicalGuidanceListValue;
	
	private transient String slCategoryTableValue;
	private transient String slContentTableValue;
	
	public String getRsnModComment() {
		return rsnModComment;
	}
	public void setRsnModComment(String rsnModComment) {
		this.rsnModComment = rsnModComment;
	}
	public DMPStandLibCatType getSlCategoryType() {
		return slCategoryType;
	}
	public void setSlCategoryType(DMPStandLibCatType slCategoryType) {
		this.slCategoryType = slCategoryType;
	}
	public DMPStandLibContentType getSlContentType() {
		return slContentType;
	}
	public void setSlContentType(DMPStandLibContentType slContentType) {
		this.slContentType = slContentType;
	}
	public String getSlContent() {
		return slContent;
	}
	public void setSlContent(String slContent) {
		this.slContent = slContent;
	}
	public Boolean getClinicalEvidenceVA() {
		return clinicalEvidenceVA;
	}
	public void setClinicalEvidenceVA(Boolean clinicalEvidenceVA) {
		this.clinicalEvidenceVA = clinicalEvidenceVA;
	}
/*	public DMPStandLibClinicalGuidanceType getClinicalGuidanceType() {
		return clinicalGuidanceType;
	}
	public void setClinicalGuidanceType(
			DMPStandLibClinicalGuidanceType clinicalGuidanceType) {
		this.clinicalGuidanceType = clinicalGuidanceType;
	}
*/	public Boolean getClinicalEvidenceOther() {
		return clinicalEvidenceOther;
	}
	public void setClinicalEvidenceOther(Boolean clinicalEvidenceOther) {
		this.clinicalEvidenceOther = clinicalEvidenceOther;
	}
	public String getCeOtherText() {
		return ceOtherText;
	}
	public void setCeOtherText(String ceOtherText) {
		this.ceOtherText = ceOtherText;
	}
	public TermType getSlCategoryTermType() {
		return slCategoryTermType;
	}
	public void setSlCategoryTermType(TermType slCategoryTermType) {
		this.slCategoryTermType = slCategoryTermType;
	}
	public TermType getSlContentTermType() {
		return slContentTermType;
	}
	public void setSlContentTermType(TermType slContentTermType) {
		this.slContentTermType = slContentTermType;
	}
/*	public TermType getClinicalGuidanceTermType() {
		return clinicalGuidanceTermType;
	}
	public void setClinicalGuidanceTermType(TermType clinicalGuidanceTermType) {
		this.clinicalGuidanceTermType = clinicalGuidanceTermType;
	}
*/	public DMPStandLibRsnModType getReasonModType() {
		return reasonModType;
	}
	public void setReasonModType(DMPStandLibRsnModType reasonModType) {
		this.reasonModType = reasonModType;
	}
	public TermType getReasonModTermType() {
		return reasonModTermType;
	}
	public void setReasonModTermType(TermType reasonModTermType) {
		this.reasonModTermType = reasonModTermType;
	}
	public String getClinicalGuidanceListValue() {
		String ceValue="";
		if(this.clinicalEvidenceVA!=null && this.clinicalEvidenceVA)
		{
			ceValue=ceValue+ "VA/DOD";
		}
		if(this.clinicalEvidenceAhrq!=null&&this.clinicalEvidenceAhrq)
		{
			if(ceValue.length()<1)
			{
				ceValue=ceValue+"AHRQ";
			}
			else
			{
				ceValue=ceValue+", AHRQ";
			}
		}
		if(this.clinicalEvidenceOther!=null&&this.clinicalEvidenceOther)
		{
			if(ceValue.length()<1)
			{
				ceValue=ceValue+"Other";
			}
			else
			{
				ceValue=ceValue+", Other";
			}
		}
		return ceValue;
	}
	public void setClinicalGuidanceListValue(String clinicalGuidanceListValue) {
		this.clinicalGuidanceListValue = clinicalGuidanceListValue;
	}
	public String getSlCategoryTableValue() {
		return slCategoryTermType.getLabel();
	}
	public void setSlCategoryTableValue(String slCategoryTableValue) {
		this.slCategoryTableValue = slCategoryTableValue;
	}
	public String getSlContentTableValue() {
		return slContentTermType.getLabel();
	}
	public void setSlContentTableValue(String slContentTableValue) {
		this.slContentTableValue = slContentTableValue;
	}
	public Boolean getClinicalEvidenceAhrq() {
		return clinicalEvidenceAhrq;
	}
	public void setClinicalEvidenceAhrq(Boolean clinicalEvidenceAhrq) {
		this.clinicalEvidenceAhrq = clinicalEvidenceAhrq;
	}
	

}
