package gov.va.med.ccht.model.dmp;

import java.util.Date;
import java.util.List;
import java.util.Set;

import org.hibernate.annotations.Formula;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.model.TermType;

public class DMPSearch extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 1035786413698200541L;
	private String name;
	private String description;
	private String objective;
	private Date dateCreated;
	private String tag;
	private String status;
//	private Set<DMPToolUser> assignees;
//	private Set<DMPQuestion> questions;
	private String question;
	private String response;
	private String assignee;
	private DMPStatusType dmpStatusType;
	private transient Boolean canEdit;
	private String createdByName;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = CREATED_BY)")	
	private String modifiedByName;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = MODIFIED_BY)")
	
	private transient boolean hasComments;

	public String getObjective() {
		return objective;
	}

	public void setObjective(String objective) {
		this.objective = objective;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	public String getDescription() {
		return description;
	}


	public String getName() {
		return name;
	}
	
	public DMPStatusType getDmpStatusType() {
		return dmpStatusType;
	}

	public void setDmpStatusType(DMPStatusType dmpStatusType) {
		this.dmpStatusType = dmpStatusType;
	}
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
		if (dmpStatusType == null)
		{
			DMPStatusType tempStatusType =  new DMPStatusType();
			tempStatusType.setCode(status);
			if (status.equalsIgnoreCase("1"))
			{
				tempStatusType.setName("Draft");
			}
			else
			{
				tempStatusType.setName("Nationally Released");
			}
			setDmpStatusType(tempStatusType);
		}
		
	}

	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public TermType getDmpStatusTermType() {
		return toTermType(getDmpStatusType());
	}

	public TermType toTermType(Lookup lookup) {
		return lookup != null ? new TermType(lookup.getName(), lookup.getCode()) : null;
	}
	
	public String toString()
	{
		String dmpString = "";
		dmpString="id = "+this.id.toString();
		dmpString=dmpString+"\n";
		dmpString=dmpString+"name = "+this.name;
		
		return dmpString;
	}
//	public Set<DMPToolUser> getAssignees() {
//		return assignees;
//	}

//	public void setAssignees(Set<DMPToolUser> assignees) {
//		this.assignees = assignees;
//	}

//	public Set<DMPQuestion> getQuestions() {
//		return questions;
//	}

//	public void setQuestions(Set<DMPQuestion> questions) {
//		this.questions = questions;
//	}

	public Boolean getCanEdit() {
		return canEdit;
	}

	public void setCanEdit(Boolean canEdit) {
		this.canEdit = canEdit;
	}

	public String getCreatedByName() {
		return createdByName;
	}

	public void setCreatedByName(String createdByName) {
		this.createdByName = createdByName;
	}

	public String getModifiedByName() {
		return modifiedByName;
	}

	public void setModifiedByName(String modifiedByName) {
		this.modifiedByName = modifiedByName;
	}

	public String getQuestion() {
		return question;
	}

	public void setQuestion(String question) {
		this.question = question;
	}

	public String getResponse() {
		return response;
	}

	public void setResponse(String response) {
		this.response = response;
	}

	public String getAssignee() {
		return assignee;
	}

	public void setAssignee(String assignee) {
		this.assignee = assignee;
	}
	
	public boolean isHasComments() {
		return hasComments;
	}

	public void setHasComments(boolean hasComments) {
		this.hasComments = hasComments;
	}
	
}
