package gov.va.med.ccht.model.dmp;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.hibernate.annotations.Formula;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.date.TimeZoneUtils;

public class DMPReview extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 8355470690894734890L;
	
	private int dmpId;
	private String dmpToolUserId;
	private String dmpContentId;
	private String dmpReviewStatusTypeId;
	@Size(min=0,max=400)
	private String contentComment;	
	@Size(min=0,max=400)
	private String freqencyComment;
	@Size(min=0,max=400)
	private String respTypeComment;
	@Size(min=0,max=400)
	private String respAlertComment;
	@Size(min=0,max=400)
	private String respContentComment;
	@Size(min=0,max=400)
	private String respBranchComment;
	@Size(min=0,max=400)
	private String respEduComment;
	@Size(min=0,max=400)
	private String respVIComment;	
	private Date reviewDate;
	private String dmpVersion;
//	private Date dateCreated;
	private String createdByName;
	private String modifiedDate;
	@Formula(value = "(select u.user_name from ht.app_user u where u.user_name = RECORD_CREATED_BY)")
	private String createdByUserName;
	@Formula(value = "(select s.name from dmp.dmp_status_type s where s.id = REVIEW_STATUS_TYPE_ID)")
	private String dmpReviewStatusTypeName;
//	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = CREATED_BY)")	
//	private String modifiedByName;
//	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = MODIFIED_BY)")	

	public int getDmpId() {
		return dmpId;
	}
	public void setDmpId(int dmpId) {
		this.dmpId = dmpId;
	}
	public String getDmpToolUserId() {
		return dmpToolUserId;
	}
	public void setDmpToolUserId(String dmpToolUserId) {
		this.dmpToolUserId = dmpToolUserId;
	}
	public String getDmpContentId() {
		return dmpContentId;
	}
	public void setDmpContentId(String dmpContentId) {
		this.dmpContentId = dmpContentId;
	}
	public String getDmpReviewStatusTypeId() {
		return dmpReviewStatusTypeId;
	}
	public void setDmpReviewStatusTypeId(String dmpReviewStatusTypeId) {
		this.dmpReviewStatusTypeId = dmpReviewStatusTypeId;
	}
	public String getContentComment() {
		return contentComment;
	}
	public void setContentComment(String contentComment) {
		this.contentComment = contentComment;
	}
	public String getFreqencyComment() {
		return freqencyComment;
	}
	public void setFreqencyComment(String freqencyComment) {
		this.freqencyComment = freqencyComment;
	}
	public String getRespTypeComment() {
		return respTypeComment;
	}
	public void setRespTypeComment(String respTypeComment) {
		this.respTypeComment = respTypeComment;
	}
	public String getRespAlertComment() {
		return respAlertComment;
	}
	public void setRespAlertComment(String respAlertComment) {
		this.respAlertComment = respAlertComment;
	}
	public String getRespContentComment() {
		return respContentComment;
	}
	public void setRespContentComment(String respContentComment) {
		this.respContentComment = respContentComment;
	}
	public String getRespEduComment() {
		return respEduComment;
	}
	public void setRespEduComment(String respEduComment) {
		this.respEduComment = respEduComment;
	}
	public String getRespVIComment() {
		return respVIComment;
	}
	public void setRespVIComment(String respVIComment) {
		this.respVIComment = respVIComment;
	}
/*	public String getCreatedByName() {
		return createdByName;
	}
	public void setCreatedByName(String createdByName) {
		this.createdByName = createdByName;
	}
	public String getModifiedByName() {
		return modifiedByName;
	}
	public void setModifiedByName(String modifiedByName) {
		this.modifiedByName = modifiedByName;
	}
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}*/

	public Date getReviewDate() {
		return reviewDate;
	}
	public void setReviewDate(Date reviewDate) {
		this.reviewDate = reviewDate;
	}
	public String getDmpVersion() {
		return dmpVersion;
	}
	public void setDmpVersion(String dmpVersion) {
		this.dmpVersion = dmpVersion;
	}
	public String getRespBranchComment() {
		return respBranchComment;
	}
	public void setRespBranchComment(String respBranchComment) {
		this.respBranchComment = respBranchComment;
	}
	public String getCreatedByName() {
		return createdByName;
	}
	public void setCreatedByName(String createdByName) {
		this.createdByName = createdByName;
	}
	
	public String getModifiedDate() {
		modifiedDate = (TimeZoneUtils.convertDateToTimeZone(this.getModifiedOn(), TimeZone.getDefault()));
		return modifiedDate;
	}
	public void setModifiedDate(String modifiedDate) {
		this.modifiedDate = modifiedDate;
	}
	public String getCreatedByUserName() {
		return createdByUserName;
	}
	public void setCreatedByUserName(String createdByUserName) {
		this.createdByUserName = createdByUserName;
	}
	public String getDmpReviewStatusTypeName() {
		return dmpReviewStatusTypeName;
	}
	public void setDmpReviewStatusTypeName(String dmpReviewStatusTypeName) {
		this.dmpReviewStatusTypeName = dmpReviewStatusTypeName;
	}
	
}
