package gov.va.med.ccht.model.dmp;

import gov.va.med.fw.model.AbstractKeyedEntity;
import javax.validation.Valid;
import javax.validation.constraints.Size;


public class DMPResponse extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 6516583058721370535L;

	private Long alertLevel = new Long(1001);
	
	@Size(min=0,max=255)
	private String responseContent = "";
	@Valid
	private DMPQuestion question;
	private Long branchId = new Long(-1);	
	@Size(min=0,max=255)
	private String eduContent = "";		
	@Size(min=0,max=255)
	private String vendorInstrContent = "";
	
	public Long getBranchId() {
		return branchId;
	}

	public void setBranchId(Long branchId) {
		this.branchId = branchId;
	}

	public Long getAlertLevel() {
		return alertLevel;
	}

	public void setAlertLevel(Long alertLevel) {
		this.alertLevel = alertLevel;
	}

	public String getResponseContent() {
		return responseContent;
	}

	public void setResponseContent(String responseContent) {
		this.responseContent = responseContent;
	}

	public DMPQuestion getQuestion() {
		return question;
	}

	public void setQuestion(DMPQuestion question) {
		this.question = question;
	}

	public String getEduContent() {
		return eduContent;
	}

	public void setEduContent(String eduContent) {
		this.eduContent = eduContent;
	}

	public String getVendorInstrContent() {
		return vendorInstrContent;
	}

	public void setVendorInstrContent(String vendorInstrContent) {
		this.vendorInstrContent = vendorInstrContent;
	}

}