/**
 * 
 */
package gov.va.med.ccht.model.dmp;

import gov.va.med.fw.ui.model.TermType;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DMPReportParameters implements Serializable {

	private static final long serialVersionUID = -8185750419457432313L;
	public static final int SEARCH_BY_DMP = 1;
	public static final int SEARCH_BY_DMP_VISN = 3;
	public static final int SEARCH_BY_DMP_FACILITY = 5;
	public static final int SEARCH_BY_DMP_VENDOR = 9;
	public static final int SEARCH_BY_DMP_VISN_VENDOR = 11;
	public static final int SEARCH_BY_DMP_FACILITY_VENDOR = 13;
	
	private Date submittedFromDate;
	private Date submittedToDate;
	private Integer maxRecords;
	
	private String dmpName;
	private List<String> dmpNameList = new ArrayList<String>();
	private List<TermType> visnList = new ArrayList<TermType>();
	private List<TermType> facilityList = new ArrayList<TermType>();
	private List<TermType> vendorList = new ArrayList<TermType>();
	private int searchBy = SEARCH_BY_DMP;
	private boolean allFacilities;
	private boolean allVisns;
	private boolean allVendors;
	
	public Date getSubmittedFromDate() {
		return submittedFromDate;
	}
	public void setSubmittedFromDate(Date submittedFromDate) {
		this.submittedFromDate = submittedFromDate;
	}
	public Date getSubmittedToDate() {
		return submittedToDate;
	}
	public void setSubmittedToDate(Date submittedToDate) {
		this.submittedToDate = submittedToDate;
	}
	public Integer getMaxRecords() {
		return maxRecords;
	}
	public void setMaxRecords(Integer maxRecords) {
		this.maxRecords = maxRecords;
	}
	
	public String getDmpName() {
		return dmpName;
	}
	public void setDmpName(String dmpName) {
		this.dmpName = dmpName;
	}
	public List<String> getDmpNameList() {
		return dmpNameList;
	}
	public void setDmpNameList(List<String> dmpNameList) {
		this.dmpNameList = dmpNameList;
	}
	
	public List<TermType> getVisnList() {
		return visnList;
	}
	public void setVisnList(List<TermType> visnList) {
		this.visnList = visnList;
	}
	public int getSearchBy() {
		return searchBy;
	}
	public void setSearchBy(int searchBy) {
		this.searchBy = searchBy;
	}
	public List<TermType> getFacilityList() {
		return facilityList;
	}
	public void setFacilityList(List<TermType> facilityList) {
		this.facilityList = facilityList;
	}
	public List<TermType> getVendorList() {
		return vendorList;
	}
	public void setVendorList(List<TermType> vendorList) {
		this.vendorList = vendorList;
	}
	public boolean isAllFacilities() {
		return allFacilities;
	}
	public void setAllFacilities(boolean allFacilities) {
		this.allFacilities = allFacilities;
	}
	public boolean isAllVisns() {
		return allVisns;
	}
	public void setAllVisns(boolean allVisns) {
		this.allVisns = allVisns;
	}
	public boolean isAllVendors() {
		return allVendors;
	}
	public void setAllVendors(boolean allVendors) {
		this.allVendors = allVendors;
	}
	
}
