package gov.va.med.ccht.model.dmp;

import java.util.Set;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.ui.model.TermType;

public class DMPQuestion extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 8355430690894734890L;

	@Valid
	private DMP dmp;
	@NotNull
	@Size(min=1,max=100)
	private String questionContent;
	@Size(min=0,max=50)
	private String frequency;
	//private String additionalInstructions;
	@Valid
	private DMPResponseType dmpResponseType;
	@Valid
	private DMPContentType dmpContentType;
	//private Long dmpContentType = new Long(1001);
	private transient TermType questionResponseTermType;
	private transient TermType questionContentTermType;
	private transient Boolean  markAsDeleted = false;
	private transient String questionTag;
	//private transient DMPQuestionOrder order;
	private int contentOrder=-1;
	private transient String questionOrder;
	@Valid
	private Set<DMPResponse> responses;
	private Boolean locked;
	@Valid
	private Set<DMPReview> reviewComments;

	public DMP getDmp() {
		return dmp;
	}
	public void setDmp(DMP dmp) {
		this.dmp = dmp;
	}
	public String getQuestionContent() {
		return questionContent;
	}
	public void setQuestionContent(String questionContent) {
		this.questionContent = questionContent;
	}
	public String getFrequency() {
		return frequency;
	}
	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}
/*	public String getAdditionalInstructions() {
		return additionalInstructions;
	}
	public void setAdditionalInstructions(String additionalInstructions) {
		this.additionalInstructions = additionalInstructions;
	}
*/	public DMPResponseType getDmpResponseType() {
		return dmpResponseType;
	}
	public void setDmpResponseType(DMPResponseType dmpResponseType) {
		this.dmpResponseType = dmpResponseType;
	}
	public TermType getQuestionResponseTermType() {
		return questionResponseTermType;
	}
	public void setQuestionResponseTermType(TermType questionResponseTermType) {
		this.questionResponseTermType = questionResponseTermType;
	}
	public String getQuestionTag() {
		return questionTag;
	}
	public void setQuestionTag(String questionTag) {
		this.questionTag = questionTag;
	}
	public Boolean getMarkAsDeleted() {
		return markAsDeleted;
	}
	public void setMarkAsDeleted(Boolean markAsDeleted) {
		this.markAsDeleted = markAsDeleted;
	}
	public void setQuestionOrder(String questionOrder) {
		this.questionOrder = questionOrder;
	}
	public String getQuestionOrder()
	{
		return this.questionOrder;
	}
/*	public DMPResponse getResponse() {
		return response;
	}
	public void setResponse(DMPResponse response) {
		this.response = response;
	}*/
	public Set<DMPResponse> getResponses() {
		return responses;
	}
	public void setResponses(Set<DMPResponse> responses) {
		this.responses = responses;
	}
	public int getContentOrder() {
		return contentOrder;
	}
	public void setContentOrder(int contentOrder) {
		this.contentOrder = contentOrder;
	}
/*	public Long getDmpContentType() {
		return dmpContentType;
	}
	public void setDmpContentType(Long dmpContentType) {
		this.dmpContentType = dmpContentType;
	}
*/	public void setDmpContentType(DMPContentType dmpContentType) {
		this.dmpContentType = dmpContentType;
	}
	public DMPContentType getDmpContentType() {
		return dmpContentType;
	}
	public TermType getQuestionContentTermType() {
		return questionContentTermType;
	}
	public void setQuestionContentTermType(TermType questionContentTermType) {
		this.questionContentTermType = questionContentTermType;
	}
	public Boolean getLocked() {
		return locked;
	}
	public void setLocked(Boolean locked) {
		this.locked = locked;
	}
	public Set<DMPReview> getReviewComments() {
		return reviewComments;
	}
	public void setReviewComments(Set<DMPReview> reviewComments) {
		this.reviewComments = reviewComments;
	}
	
}
