package gov.va.med.ccht.model.dmp;

import java.util.Date;
import java.util.Set;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.hibernate.annotations.Formula;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.model.TermType;

public class DMP extends AbstractKeyedEntity<Object> 
{

	private static final long serialVersionUID = 1035786413698200541L;

	@NotNull	
	@Size(min=1,max=100)
	private String name;
	@NotNull
	@Size(min=1,max=250)
	private String description;
	@NotNull
	@Size(min=1,max=250)
	private String objective;
	private Date dateCreated;
	@NotNull
	@Size(min=1,max=25)
	private String tag;
	private String dmpVersion;
	@Valid
	private Set<DMPToolUser> assignees;
	@Valid
	private Set<DMPQuestion> questions;
	@Valid 
	private DMPStatusType dmpStatusType;
	private transient Boolean canEdit;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")	
	private String createdByName;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_MODIFIED_BY)")	
	private String modifiedByName;
	@Formula(value = "(select isnull(u.first_name,'') + ' ' + isnull(u.last_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")	
	private String emailSubmittedByName = null;
	@Formula(value = "(select u.app_user_id from ht.app_user u where u.user_name = RECORD_CREATED_BY)")
    private Long createdById;
	
	private Set<DMPToolUser> reviewers;
	private transient boolean hasComments;
	
 
	public String getEmailSubmittedByName() {
		return emailSubmittedByName;
	}

	public void setEmailSubmittedByName(String emailSubmittedByName) {
		this.emailSubmittedByName = emailSubmittedByName;
	}

	public String getObjective() {
		return objective;
	}

	public void setObjective(String objective) {
		this.objective = objective;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	public String getDescription() {
		return description;
	}


	public String getName() {
		return name;
	}

	public DMPStatusType getDmpStatusType() {
		return dmpStatusType;
	}

	public void setDmpStatusType(DMPStatusType dmpStatusType) {
		this.dmpStatusType = dmpStatusType;
	}
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public TermType getDmpStatusTermType() {
		return toTermType(getDmpStatusType());
	}

	public TermType toTermType(Lookup lookup) {
		return lookup != null ? new TermType(lookup.getName(), lookup.getCode()) : null;
	}
	
	public String toString()
	{
		String dmpString = "";
		dmpString="id = "+this.id.toString();
		dmpString=dmpString+"\n";
		dmpString=dmpString+"name = "+this.name;
		
		return dmpString;
	}
	public Set<DMPToolUser> getAssignees() {
		return assignees;
	}

	public void setAssignees(Set<DMPToolUser> assignees) {
		this.assignees = assignees;
	}

	public Set<DMPQuestion> getQuestions() {
		return questions;
	}

	public void setQuestions(Set<DMPQuestion> questions) {
		this.questions = questions;
	}

	public Boolean getCanEdit() {
		return canEdit;
	}

	public void setCanEdit(Boolean canEdit) {
		this.canEdit = canEdit;
	}

	public String getCreatedByName() {
		return createdByName;
	}

	public void setCreatedByName(String createdByName) {
		this.createdByName = createdByName;
	}

	public String getModifiedByName() {
		return modifiedByName;
	}

	public void setModifiedByName(String modifiedByName) {
		this.modifiedByName = modifiedByName;
	}
	public String getDmpVersion() {
		return dmpVersion;
	}

	public void setDmpVersion(String dmpVersion) {
		this.dmpVersion = dmpVersion;
	}

	public Long getCreatedById() {
		return createdById;
	}

	public void setCreatedById(Long createdById) {
		this.createdById = createdById;
	}

	public Set<DMPToolUser> getReviewers() {
		return reviewers;
	}

	public void setReviewers(Set<DMPToolUser> reviewers) {
		this.reviewers = reviewers;
	}

	public boolean isHasComments() {
		return hasComments;
	}

	public void setHasComments(boolean hasComments) {
		this.hasComments = hasComments;
	}
	
}
