package gov.va.med.ccht.model.car;

import gov.va.med.fw.ui.model.TermType;

import java.io.Serializable;
import java.util.Date;

public class CensusActivityReportParameters implements Serializable 
{	
	private static final long serialVersionUID = -7242591894427956373L;

	public static final int NATIONAL = 0;
	public static final int VISN = 1;
	public final static int FACILITY = 2;
	
	private int reportType;
	private Date weekEndingDate;
	private TermType modality;
	private TermType vendor;
	private boolean showVendorSubTotals;
	
	public int getReportType() {
		return reportType;
	}
	public void setReportType(int reportType) {
		this.reportType = reportType;
	}
	public Date getWeekEndingDate() {
		return weekEndingDate;
	}
	public void setWeekEndingDate(Date weekEndingDate) {
		this.weekEndingDate = weekEndingDate;
	}
	public TermType getModality() {
		return modality;
	}
	public void setModality(TermType modality) {
		this.modality = modality;
	}
	public TermType getVendor() {
		return vendor;
	}
	public void setVendor(TermType vendor) {
		this.vendor = vendor;
	}
	public boolean isShowVendorSubTotals() {
		return showVendorSubTotals;
	}
	public void setShowVendorSubTotals(boolean showVendorSubTotals) {
		this.showVendorSubTotals = showVendorSubTotals;
	}
	
	
	public String getColumnNameForModality()
	{
		String columnName = null;
		
		if(modality !=  null)
		{
			String chosenModality = modality.getValue();
			
			columnName = chosenModality.replaceAll(" ", "");
			
			if(columnName.contains("Peripheral"))
			{
				columnName = "Measurement";
			}
			else if(columnName.contains("notyetassigned"))
			{
				columnName = "MessagingUnknown";
			}
			else if(columnName.contains("Cellular"))
			{
				columnName = "CellModem";
			}
			else if(columnName.contains("Satellite"))
			{
				columnName = "Satellite";
			}
			else if(columnName.contains("Digital"))
			{
				columnName = "DigImageCapture";
			}
			else if(columnName.contains("MessagingTotal"))
			{
				columnName = "Dialogue";
			}
			else if(columnName.contains("Browser"))
			{
				columnName = "Browser";
			}
			
		}
		else
		{
			columnName = "";
		}
		
		return columnName;		
		
	}
	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((modality == null) ? 0 : modality.hashCode());
		result = prime * result + reportType;
		result = prime * result + (showVendorSubTotals ? 1231 : 1237);
		result = prime * result + ((vendor == null) ? 0 : vendor.hashCode());
		result = prime * result
				+ ((weekEndingDate == null) ? 0 : weekEndingDate.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CensusActivityReportParameters other = (CensusActivityReportParameters) obj;
		if (modality == null) {
			if (other.modality != null)
				return false;
		} else if (!modality.equals(other.modality))
			return false;
		if (reportType != other.reportType)
			return false;
		if (showVendorSubTotals != other.showVendorSubTotals)
			return false;
		if (vendor == null) {
			if (other.vendor != null)
				return false;
		} else if (!vendor.equals(other.vendor))
			return false;
		if (weekEndingDate == null) {
			if (other.weekEndingDate != null)
				return false;
		} else if (!weekEndingDate.equals(other.weekEndingDate))
			return false;
		return true;
	}
	@Override
	public String toString() {
		return "CensusActivityReportParameters [modality=" + modality
				+ ", reportType=" + reportType + ", showVendorSubTotals="
				+ showVendorSubTotals + ", vendor=" + vendor
				+ ", weekEndingDate=" + weekEndingDate + "]";
	}
	
	

}
