package gov.va.med.ccht.model.car;

import gov.va.med.fw.ui.model.TermType;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CensusActivityRecord implements Serializable 
{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7932072567700379138L;
	
	private List<TermType> reportWeek;
	private String modalityName;
	private Integer total;
	private Integer nationalTotal;
	

	public List<TermType> getReportWeek() 
	{
		if(reportWeek != null)
		{
			return reportWeek;
		}
		else
		{
			return new ArrayList<TermType>();
		}
	}

	public void setReportWeek(List<TermType> reportWeek) {
		this.reportWeek = reportWeek;
	}
	
	public String getModalityName() 
	{
		if(modalityName != null)
		{
			return modalityName;
		}
		else
		{
			return "No Modality Assigned";
		}
	}
	
	public void setModalityName(String modalityName) 
	{
		this.modalityName = modalityName;
	}
	
	public Integer getTotal() 
	{
		if(total != null)
		{
			return total;
		}
		else
		{
			return 0;
		}
	}
	
	public void setTotal(Integer total) 
	{
		this.total = total;
	}
	
	public Integer getNationalTotal() 
	{
		if(nationalTotal != null)
		{
			return nationalTotal;
		}
		else
		{
			return 0;
		}
	}
	
	public void setNationalTotal(Integer nationalTotal) 
	{
		this.nationalTotal = nationalTotal;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((modalityName == null) ? 0 : modalityName.hashCode());
		result = prime * result
				+ ((nationalTotal == null) ? 0 : nationalTotal.hashCode());
		result = prime * result
		+ ((reportWeek == null) ? 0 : reportWeek.hashCode());
		result = prime * result + ((total == null) ? 0 : total.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CensusActivityRecord other = (CensusActivityRecord) obj;
		if (modalityName == null) {
			if (other.modalityName != null)
				return false;
		} else if (!modalityName.equals(other.modalityName))
			return false;
		if (nationalTotal == null) {
			if (other.nationalTotal != null)
				return false;
		} else if (!nationalTotal.equals(other.nationalTotal))
			return false;
		if (total == null) {
			if (other.total != null)
				return false;
		} else if (!total.equals(other.total))
			return false;
		
		if (reportWeek == null) {
			if (other.reportWeek != null)
				return false;
		} else if (!total.equals(other.reportWeek))
			return false;
		return true;
	}

	


	@Override
	public String toString() {
		return "CensusActivityRecord [modalityName=" + modalityName
				+ ", nationalTotal=" + nationalTotal + ", reportWeek="
				+ reportWeek + ", total=" + total + "]";
	}
	
	
		

}
