package gov.va.med.ccht.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.model.ldap.LdapPerson;

import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.SimpleVisn;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.terminology.InactiveReason;
import gov.va.med.ccht.model.terminology.RegistrationDeniedReason;
import gov.va.med.ccht.model.terminology.RegistrationReason;
import gov.va.med.ccht.model.terminology.RegistrationStatus;

public class User extends UserPrincipalImpl {

	private static final long serialVersionUID = 8175242732620450379L;
	
	@Valid
	private InactiveReason inactiveReason;
	@Valid
	private RegistrationStatus registrationStatus;
	@Valid
	private RegistrationDeniedReason registrationDeniedReason;
	@Valid
	private SimpleVisn visn;
	@Valid
	private SimpleFacility facility;
	@Valid
	private SimpleFacility secondaryFacility;
	@Valid
	private Vendor vendor;
		
	private Date accountExpireDate;
	private Date accountLockDate;
	private Date inactiveDate;
	private Date loginFailedDate;
	private Date lastLoginDate;
	private Integer loginFailedCount;
	@Valid
	private RegistrationReason registrationReason;
	@Valid
	private Set<UserRole> internalRoles;
	@Valid
	private Set<AppUserGroup> internalUserGroups;
	@Valid
	private Set<UserPreference> internalPreferences;

	public User() {
		super();
	}
	public User(String name) {
		super(name);
	}
	public User(SimpleUser simpleUser) {
		super(simpleUser.getUsername());
		setGivenName(simpleUser.getGivenName());
		setMiddleName(simpleUser.getMiddleName());
		setFamilyName(simpleUser.getFamilyName());
		setEmail(simpleUser.getEmail());
		setTelephoneNumber(simpleUser.getTelephoneNumber());
	}	
	public User(LdapPerson person){
		setLdapPerson(person);
	}
	
	public InactiveReason getInactiveReason() {
		return inactiveReason;
	}
	public void setInactiveReason(InactiveReason inactiveReason) {
		this.inactiveReason = inactiveReason;
	}
	public RegistrationStatus getRegistrationStatus() {
		return registrationStatus;
	}
	public void setRegistrationStatus(RegistrationStatus registrationStatus) {
		this.registrationStatus = registrationStatus;
	}
	public RegistrationDeniedReason getRegistrationDeniedReason() {
		return registrationDeniedReason;
	}
	public void setRegistrationDeniedReason(
			RegistrationDeniedReason registrationDeniedReason) {
		this.registrationDeniedReason = registrationDeniedReason;
	}
	public SimpleVisn getVisn() {
		return visn;
	}
	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}
	public Date getAccountExpireDate() {
		return accountExpireDate;
	}
	public void setAccountExpireDate(Date accountExpireDate) {
		this.accountExpireDate = accountExpireDate;
	}
	public Date getAccountLockDate() {
		return accountLockDate;
	}
	public void setAccountLockDate(Date accountLockDate) {
		this.accountLockDate = accountLockDate;
	}
	public Date getInactiveDate() {
		return inactiveDate;
	}
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}
	public Date getLoginFailedDate() {
		return loginFailedDate;
	}
	public void setLoginFailedDate(Date loginFailedDate) {
		this.loginFailedDate = loginFailedDate;
	}
	public Date getLastLoginDate() {
		return lastLoginDate;
	}
	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}
	public Integer getLoginFailedCount() {
		return loginFailedCount;
	}
	public void setLoginFailedCount(Integer loginFailedCount) {
		this.loginFailedCount = loginFailedCount;
	}
	public RegistrationReason getRegistrationReason() {
		return registrationReason;
	}
	public void setRegistrationReason(RegistrationReason registrationReason) {
		this.registrationReason = registrationReason;
	}
	public SimpleFacility getFacility() {
		return facility;
	}
	public void setFacility(SimpleFacility facility) {
		this.facility = facility;
	}
	public SimpleFacility getSecondaryFacility() {
		return secondaryFacility;
	}
	public void setSecondaryFacility(SimpleFacility secondaryFacility) {
		this.secondaryFacility = secondaryFacility;
	}
	public Vendor getVendor() {
		return vendor;
	}
	public void setVendor(Vendor vendor) {
		this.vendor = vendor;
	}
	private Set<UserRole> getInternalRoles() {
		if (internalRoles == null) 
			internalRoles = new HashSet<UserRole>();
		return internalRoles;
	}
	@SuppressWarnings("unused")
	private void setInternalRoles(Set<UserRole> internalRoles) {
		this.internalRoles = internalRoles;
	}
	private Set<AppUserGroup> getInternalUserGroups() {
		if (internalUserGroups == null)
			internalUserGroups = new HashSet<AppUserGroup>();
		return internalUserGroups;
	}
	@SuppressWarnings("unused")
	private void setInternalUserGroups(Set<AppUserGroup> internalUserGroups) {
		this.internalUserGroups = internalUserGroups;
	}
	private Set<UserPreference> getInternalPreferences() {
		if (internalPreferences == null)
			internalPreferences = new HashSet<UserPreference>();
		return internalPreferences;
	}
	@SuppressWarnings("unused")
	private void setInternalPreferences(Set<UserPreference> internalPreferences) {
		this.internalPreferences = internalPreferences;
	}
	
	//Role
	public Set<UserRole> getRoles() {
		return Collections.unmodifiableSet(getInternalRoles());
	}
	public void addRole(UserRole userRole) {
		if (userRole != null) {
			userRole.setUser(this);
			getInternalRoles().add(userRole);
		}
	}
	public void removeRole(UserRole userRole) {
		if (userRole != null) {
			userRole.setUser(null);
			getInternalRoles().remove(userRole);
		}
	}	
	
	//Usergroup
	public Set<AppUserGroup> getUserGroups() {
		return Collections.unmodifiableSet(getInternalUserGroups());
	}
	public void addUserGroup(AppUserGroup userGroup) {
		if (userGroup != null) {
			userGroup.setUser(this);
			getInternalUserGroups().add(userGroup);
		}
	}
	public void removeUserGroup(AppUserGroup userGroup) {
		if (userGroup != null) {
			userGroup.setUser(null);
			getInternalUserGroups().remove(userGroup);
		}
	}		
	
	//UserPreferences
	public Set<UserPreference> getPreferencees() {
		return Collections.unmodifiableSet(getInternalPreferences());
	}
	
	public String getPreferenceValue(String name) {
		if (name != null) {
			for (UserPreference userPreference: getInternalPreferences()) {
				if (userPreference.getName().equalsIgnoreCase(name)) {
					return userPreference.getValue();
				}
			}
		}
		return null;
	}
	
	public void addPreference(UserPreference userPreference) {
		if (userPreference != null) {
			userPreference.setUser(this);
			getInternalPreferences().add(userPreference);
		}
	}
	public void addOrUpdatePreference(String name, String value) {
		if (name != null) {
			for (UserPreference userPreference: getInternalPreferences()) {
				if (userPreference.getName().equalsIgnoreCase(name)) {
					userPreference.setValue(value);
					return;
				}
			}
			//not found new value
			UserPreference userPreference = new UserPreference();
			userPreference.setName(name);
			userPreference.setValue(value);
			addPreference(userPreference);	
		}
	}
	
	public void removePreference(UserPreference userPreference) {
		if (userPreference != null) {
			userPreference.setUser(null);
			getInternalPreferences().remove(userPreference);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.UserPrincipalImpl#getCachedRoles()
	 */
	@Override
	public Set<String> getCachedRoles() {
		Set<String> cachedRoles = new HashSet<String>();
		for(UserRole role : getInternalRoles()) {
			cachedRoles.add(role.getRole().getName());
		}
		return cachedRoles;
	}
	
	@Override
	public boolean isAccountLocked() {
		return (accountLockDate != null);
	}

	@Override
	public boolean isInactive() {
		if (inactiveDate != null && inactiveDate.before(new Date())) {
			return true;
		}
		return false;
	}
	
	public String toString() { 
		return getUsername();
	}
}