package gov.va.med.ccht.model;

import java.util.Date;

import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.model.ldap.LdapPerson;

import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.SimpleVisn;
import gov.va.med.ccht.model.inventory.Vendor;

public class SimpleUser extends UserPrincipalImpl {

	private static final long serialVersionUID = 8175242732620450379L;
	private SimpleVisn visn;
	private SimpleFacility facility;
	private SimpleFacility secondaryFacility;
	private Vendor vendor;
	private Date inactiveDate;
	
	public SimpleUser() {
		super();
	}
	public SimpleUser(String name) {
		super(name);
	}
	public SimpleUser(LdapPerson person){
		setLdapPerson(person);
	}

	public String toString() { 
		return getUsername();
	}
	public SimpleVisn getVisn() {
		return visn;
	}
	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}
	public SimpleFacility getFacility() {
		return facility;
	}
	public void setFacility(SimpleFacility facility) {
		this.facility = facility;
	}
	public SimpleFacility getSecondaryFacility() {
		return secondaryFacility;
	}
	public void setSecondaryFacility(SimpleFacility secondaryFacility) {
		this.secondaryFacility = secondaryFacility;
	}
	public Vendor getVendor() {
		return vendor;
	}
	public void setVendor(Vendor vendor) {
		this.vendor = vendor;
	}
	public Date getInactiveDate() {
		return inactiveDate;
	}
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}
}