/**
 * 
 */
package gov.va.med.ccht.model;

import java.util.Date;

import org.hibernate.annotations.Formula;

import gov.va.med.ccht.model.terminology.DocumentType;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * @author vhaisakatikm
 *
 */
public class Attachment extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 6535335253594041933L;
	private Date date = null;
	private DocumentType documentType = null;
	private String documentName = null;	
	
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")	
	private String submittedByName = null;	
	
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	public DocumentType getDocumentType() {
		return documentType;
	}
	public void setDocumentType(DocumentType documentType) {
		this.documentType = documentType;
	}
	public String getDocumentName() {
		return documentName;
	}
	public void setDocumentName(String documentName) {
		this.documentName = documentName;
	}	
	public String getSubmittedByName() {
		return submittedByName;
	}
	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}
}