package gov.va.med.ccht.builder;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.service.jms.JMSMetaData;
import gov.va.med.fw.service.jms.WrappedObjectBuilder;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.model.terminology.StandardReport;
import gov.va.med.ccht.service.report.ReportConstants;
import gov.va.med.ccht.service.report.ReportParameterConversionService;

/**
 * @author Muddaiah Ranga
 */
public class ReportSetupBuilder extends AbstractBuilder implements ReportConstants {

	private static final long serialVersionUID = -1167633049420638791L;
	private ReportParameterConversionService reportParameterConversionService = null;

	@SuppressWarnings("unchecked")
	public Object build(Object object) throws BuilderException {
		Map<String, String> reportData = (Map<String, String>) WrappedObjectBuilder
				.getWrappedObject(((JMSMetaData) object).getJMSMessage());

		try {
			if (reportData != null) {
				Map<String, Object> reportDataMap = new HashMap<String, Object>();
				ReportSetup reportSetup = null;
				String reportSetupId = (String) reportData.get(REPORT_SETUP_ID);

				// On Demand Report
				if (reportSetupId == null) {
					reportSetup = new ReportSetup();
					// get and set the properties
					reportSetup.setReportParametersText(reportData.get(REPORT_PARAMETERS));
					reportSetup.setReportScheduleText(reportData.get(REPORT_SCHEDULE));
					reportSetup.setEmailAddress(reportData.get(REPORT_PARAM_EMAIL_REPORT_TO));
					reportSetup.setSetupUser(reportData.get(REPORT_PARAM_USER));
					String standardReportCode = reportData.get(REPORT_STANDARD_TYPE);
					StandardReport standardReport = getTerminologyService().getByCode(
							StandardReport.class, standardReportCode);
					reportSetup.setStandardReport(standardReport);
					String fileTypeCode = reportData.get(REPORT_PARAM_FILE_TYPE);
					ReportExportedType fileType = getTerminologyService().getByCode(
							ReportExportedType.class, fileTypeCode);
					reportSetup.setFileType(fileType);

					// update parameters and schedule from text to objects
					reportParameterConversionService.convertFromText(reportSetup);
					reportDataMap.put(REPORT_SETUP, reportSetup);
				}// Scheduled Report
				else {
					reportDataMap.put(REPORT_SETUP_ID, reportSetupId);
				}
				return reportDataMap;
			}
		} catch (Exception ex) {
			throw new BuilderException("ReportSetupBuilder.build failed: " + ex.getMessage(), ex);
		}
		return null;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		Validate.notNull(reportParameterConversionService,
				"Missing required ReportParameterConversionService");
	}

	public ReportParameterConversionService getReportParameterConversionService() {
		return reportParameterConversionService;
	}

	public void setReportParameterConversionService(
			ReportParameterConversionService reportParameterConversionService) {
		this.reportParameterConversionService = reportParameterConversionService;
	}
}
