<?xml version="1.0" encoding="UTF-8"?>
<!--  This stylesheet removes the errorId elements from the error section of the VHIM3400 xsd -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:act2="Act" xmlns:allergies2="Allergies" xmlns:clinicaldata="Clinicaldata" xmlns:common2="Common" xmlns:participation2="Participation" xmlns:vitals2="Vitals" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:act="Act" xmlns:allergies="Allergies" xmlns="Clinicaldata" xmlns:common="Common" xmlns:participation="Participation" xmlns:vitals="Vitals" exclude-result-prefixes="act2 allergies2 clinicaldata common2 participation2 vitals2 xs">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/clinicaldata:clinicalData">
		<clinicalData>
			<xsl:for-each select="@templateId">
				<xsl:attribute name="templateId">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="@templateName">
				<xsl:attribute name="templateName">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="@templateDescription">
				<xsl:attribute name="templateDescription">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="@vhimVersion">
				<xsl:attribute name="vhimVersion">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="@requestType">
				<xsl:attribute name="requestType">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="@entryPoint">
				<xsl:attribute name="entryPoint">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="errors">
				<errors xmlns="">
					<xsl:for-each select="fatalError">
						<fatalError>
							<xsl:for-each select="exception">
								<exception>
									<xsl:value-of select="."/>
								</exception>
							</xsl:for-each>
							<xsl:for-each select="exceptionMessage">
								<exceptionMessage>
									<xsl:value-of select="."/>
								</exceptionMessage>
							</xsl:for-each>
							<xsl:for-each select="errorCode">
								<errorCode>
									<xsl:value-of select="."/>
								</errorCode>
							</xsl:for-each>
							<xsl:for-each select="displayMessage">
								<displayMessage>
									<xsl:value-of select="."/>
								</displayMessage>
							</xsl:for-each>
						</fatalError>
					</xsl:for-each>
					<xsl:for-each select="error">
						<error>
							<xsl:for-each select="exception">
								<exception>
									<xsl:value-of select="."/>
								</exception>
							</xsl:for-each>
							<xsl:for-each select="exceptionMessage">
								<exceptionMessage>
									<xsl:value-of select="."/>
								</exceptionMessage>
							</xsl:for-each>
							<xsl:for-each select="errorCode">
								<errorCode>
									<xsl:value-of select="."/>
								</errorCode>
							</xsl:for-each>
							<xsl:for-each select="displayMessage">
								<displayMessage>
									<xsl:value-of select="."/>
								</displayMessage>
							</xsl:for-each>
						</error>
					</xsl:for-each>
					<xsl:for-each select="warning">
						<warning>
							<xsl:for-each select="exception">
								<exception>
									<xsl:value-of select="."/>
								</exception>
							</xsl:for-each>
							<xsl:for-each select="exceptionMessage">
								<exceptionMessage>
									<xsl:value-of select="."/>
								</exceptionMessage>
							</xsl:for-each>
							<xsl:for-each select="errorCode">
								<errorCode>
									<xsl:value-of select="."/>
								</errorCode>
							</xsl:for-each>
							<xsl:for-each select="displayMessage">
								<displayMessage>
									<xsl:value-of select="."/>
								</displayMessage>
							</xsl:for-each>
						</warning>
					</xsl:for-each>
				</errors>
			</xsl:for-each>
			<intoleranceCondition xmlns="">
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="dataEnterer">
						<dataEnterer>
							<xsl:for-each select="@comments">
								<xsl:attribute name="comments">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@practitionerParticipationType">
								<xsl:attribute name="practitionerParticipationType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="time">
								<time>
									<xsl:for-each select="@high">
										<xsl:attribute name="high">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_value">
										<xsl:attribute name="width_value">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_unit">
										<xsl:attribute name="width_unit">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</time>
							</xsl:for-each>
							<xsl:for-each select="signature">
								<signature/>
							</xsl:for-each>
						</dataEnterer>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="author">
						<author>
							<xsl:for-each select="@comments">
								<xsl:attribute name="comments">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@practitionerParticipationType">
								<xsl:attribute name="practitionerParticipationType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="time">
								<time>
									<xsl:for-each select="@high">
										<xsl:attribute name="high">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_value">
										<xsl:attribute name="width_value">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_unit">
										<xsl:attribute name="width_unit">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</time>
							</xsl:for-each>
							<xsl:for-each select="signature">
								<signature/>
							</xsl:for-each>
						</author>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="reactionObservationEvent">
						<reactionObservationEvent>
							<xsl:for-each select="@noReaction">
								<xsl:attribute name="noReaction">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@description">
								<xsl:attribute name="description">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="id">
								<id>
									<xsl:for-each select="@assigningAuthorityName">
										<xsl:attribute name="assigningAuthorityName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@extension">
										<xsl:attribute name="extension">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@root">
										<xsl:attribute name="root">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</id>
							</xsl:for-each>
							<xsl:for-each select="status">
								<status>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</status>
							</xsl:for-each>
							<xsl:for-each select="reaction">
								<reaction>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@nullFlavor">
										<xsl:attribute name="nullFlavor">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@otherCode">
										<xsl:attribute name="otherCode">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@otherDisplayName">
										<xsl:attribute name="otherDisplayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</reaction>
							</xsl:for-each>
							<xsl:for-each select="onsetDate">
								<onsetDate>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</onsetDate>
							</xsl:for-each>
							<xsl:for-each select="author">
								<author>
									<xsl:for-each select="@comments">
										<xsl:attribute name="comments">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@practitionerParticipationType">
										<xsl:attribute name="practitionerParticipationType">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@vpid">
										<xsl:attribute name="vpid">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="time">
										<time>
											<xsl:for-each select="@high">
												<xsl:attribute name="high">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@literal">
												<xsl:attribute name="literal">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@low">
												<xsl:attribute name="low">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@width_value">
												<xsl:attribute name="width_value">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@width_unit">
												<xsl:attribute name="width_unit">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
										</time>
									</xsl:for-each>
									<xsl:for-each select="signature">
										<signature/>
									</xsl:for-each>
								</author>
							</xsl:for-each>
							<xsl:for-each select="severityObservationEvent">
								<severityObservationEvent>
									<xsl:for-each select="id">
										<id>
											<xsl:for-each select="@assigningAuthorityName">
												<xsl:attribute name="assigningAuthorityName">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@extension">
												<xsl:attribute name="extension">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@root">
												<xsl:attribute name="root">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
										</id>
									</xsl:for-each>
									<xsl:for-each select="value">
										<value>
											<xsl:for-each select="@codeSet">
												<xsl:attribute name="codeSet">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@code">
												<xsl:attribute name="code">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@displayName">
												<xsl:attribute name="displayName">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@nullFlavor">
												<xsl:attribute name="nullFlavor">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
										</value>
									</xsl:for-each>
									<xsl:for-each select="severityValueHistory">
										<severityValueHistory>
											<xsl:for-each select="@changedBy">
												<xsl:attribute name="changedBy">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@changedDate">
												<xsl:attribute name="changedDate">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="value">
												<value>
													<xsl:for-each select="@codeSet">
														<xsl:attribute name="codeSet">
															<xsl:value-of select="."/>
														</xsl:attribute>
													</xsl:for-each>
													<xsl:for-each select="@code">
														<xsl:attribute name="code">
															<xsl:value-of select="."/>
														</xsl:attribute>
													</xsl:for-each>
													<xsl:for-each select="@displayName">
														<xsl:attribute name="displayName">
															<xsl:value-of select="."/>
														</xsl:attribute>
													</xsl:for-each>
													<xsl:for-each select="@nullFlavor">
														<xsl:attribute name="nullFlavor">
															<xsl:value-of select="."/>
														</xsl:attribute>
													</xsl:for-each>
												</value>
											</xsl:for-each>
										</severityValueHistory>
									</xsl:for-each>
								</severityObservationEvent>
							</xsl:for-each>
							<xsl:for-each select="reactionOnsetHistory">
								<reactionOnsetHistory>
									<xsl:for-each select="@changedBy">
										<xsl:attribute name="changedBy">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@changedDate">
										<xsl:attribute name="changedDate">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="onsetDate">
										<onsetDate>
											<xsl:for-each select="@literal">
												<xsl:attribute name="literal">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@low">
												<xsl:attribute name="low">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
										</onsetDate>
									</xsl:for-each>
									<xsl:for-each select="reaction">
										<reaction>
											<xsl:for-each select="@codeSet">
												<xsl:attribute name="codeSet">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@code">
												<xsl:attribute name="code">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@displayName">
												<xsl:attribute name="displayName">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@nullFlavor">
												<xsl:attribute name="nullFlavor">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@otherCode">
												<xsl:attribute name="otherCode">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@otherDisplayName">
												<xsl:attribute name="otherDisplayName">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
										</reaction>
									</xsl:for-each>
								</reactionOnsetHistory>
							</xsl:for-each>
						</reactionObservationEvent>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="severityObservationEvent">
						<severityObservationEvent>
							<xsl:for-each select="id">
								<id>
									<xsl:for-each select="@assigningAuthorityName">
										<xsl:attribute name="assigningAuthorityName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@extension">
										<xsl:attribute name="extension">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@root">
										<xsl:attribute name="root">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</id>
							</xsl:for-each>
							<xsl:for-each select="value">
								<value>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@nullFlavor">
										<xsl:attribute name="nullFlavor">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</value>
							</xsl:for-each>
							<xsl:for-each select="severityValueHistory">
								<severityValueHistory>
									<xsl:for-each select="@changedBy">
										<xsl:attribute name="changedBy">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@changedDate">
										<xsl:attribute name="changedDate">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="value">
										<value>
											<xsl:for-each select="@codeSet">
												<xsl:attribute name="codeSet">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@code">
												<xsl:attribute name="code">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@displayName">
												<xsl:attribute name="displayName">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
											<xsl:for-each select="@nullFlavor">
												<xsl:attribute name="nullFlavor">
													<xsl:value-of select="."/>
												</xsl:attribute>
											</xsl:for-each>
										</value>
									</xsl:for-each>
								</severityValueHistory>
							</xsl:for-each>
						</severityObservationEvent>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="serviceLocation">
						<serviceLocation>
							<xsl:for-each select="vlid">
								<vlid>
									<xsl:value-of select="."/>
								</vlid>
							</xsl:for-each>
						</serviceLocation>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="statusHistory">
						<statusHistory>
							<xsl:for-each select="@changedBy">
								<xsl:attribute name="changedBy">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@changedDate">
								<xsl:attribute name="changedDate">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="status">
								<status>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</status>
							</xsl:for-each>
						</statusHistory>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="intoleranceCondition">
					<xsl:for-each select="verifiers">
						<verifiers>
							<xsl:for-each select="@comments">
								<xsl:attribute name="comments">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@practitionerParticipationType">
								<xsl:attribute name="practitionerParticipationType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="time">
								<time>
									<xsl:for-each select="@high">
										<xsl:attribute name="high">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_value">
										<xsl:attribute name="width_value">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_unit">
										<xsl:attribute name="width_unit">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</time>
							</xsl:for-each>
							<xsl:for-each select="signature">
								<signature/>
							</xsl:for-each>
						</verifiers>
					</xsl:for-each>
				</xsl:for-each>
			</intoleranceCondition>
			<xsl:for-each select="vitalSignObservationEvent">
				<vitalSignObservationEvent xmlns="">
					<xsl:for-each select="@observationEventType">
						<xsl:attribute name="observationEventType">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="@observationValueInteger">
						<xsl:attribute name="observationValueInteger">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="@observationValueRatioNumerator">
						<xsl:attribute name="observationValueRatioNumerator">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="@observationValueRatioDenominator">
						<xsl:attribute name="observationValueRatioDenominator">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="@observationValuePhysicalValue1">
						<xsl:attribute name="observationValuePhysicalValue1">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="@observationValuePhysicalValue2">
						<xsl:attribute name="observationValuePhysicalValue2">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="id">
						<id>
							<xsl:for-each select="@assigningAuthorityName">
								<xsl:attribute name="assigningAuthorityName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@extension">
								<xsl:attribute name="extension">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@root">
								<xsl:attribute name="root">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</id>
					</xsl:for-each>
					<xsl:for-each select="observedCharacteristic">
						<observedCharacteristic>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observedCharacteristic>
					</xsl:for-each>
					<xsl:for-each select="status">
						<status>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</status>
					</xsl:for-each>
					<xsl:for-each select="observationTime">
						<observationTime>
							<xsl:for-each select="@literal">
								<xsl:attribute name="literal">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@low">
								<xsl:attribute name="low">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observationTime>
					</xsl:for-each>
					<xsl:for-each select="observationValueCode">
						<observationValueCode>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observationValueCode>
					</xsl:for-each>
					<xsl:for-each select="observationValuePhysicalCode1">
						<observationValuePhysicalCode1>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observationValuePhysicalCode1>
					</xsl:for-each>
					<xsl:for-each select="observationValuePhysicalCode2">
						<observationValuePhysicalCode2>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observationValuePhysicalCode2>
					</xsl:for-each>
					<xsl:for-each select="observedCharacteristic2">
						<observedCharacteristic2>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observedCharacteristic2>
					</xsl:for-each>
					<xsl:for-each select="observedCharacteristic1">
						<observedCharacteristic1>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observedCharacteristic1>
					</xsl:for-each>
					<xsl:for-each select="observationMethod">
						<observationMethod>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</observationMethod>
					</xsl:for-each>
					<xsl:for-each select="bodySite">
						<bodySite>
							<xsl:for-each select="@codeSet">
								<xsl:attribute name="codeSet">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@code">
								<xsl:attribute name="code">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@displayName">
								<xsl:attribute name="displayName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</bodySite>
					</xsl:for-each>
					<xsl:for-each select="serviceLocation">
						<serviceLocation>
							<xsl:for-each select="vlid">
								<vlid>
									<xsl:value-of select="."/>
								</vlid>
							</xsl:for-each>
						</serviceLocation>
					</xsl:for-each>
					<xsl:for-each select="subject">
						<subject>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
						</subject>
					</xsl:for-each>
					<xsl:for-each select="author">
						<author>
							<xsl:for-each select="@comments">
								<xsl:attribute name="comments">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@practitionerParticipationType">
								<xsl:attribute name="practitionerParticipationType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="time">
								<time>
									<xsl:for-each select="@high">
										<xsl:attribute name="high">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_value">
										<xsl:attribute name="width_value">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_unit">
										<xsl:attribute name="width_unit">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</time>
							</xsl:for-each>
							<xsl:for-each select="signature">
								<signature/>
							</xsl:for-each>
						</author>
					</xsl:for-each>
					<xsl:for-each select="dataEnterer">
						<dataEnterer>
							<xsl:for-each select="@comments">
								<xsl:attribute name="comments">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@practitionerParticipationType">
								<xsl:attribute name="practitionerParticipationType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="time">
								<time>
									<xsl:for-each select="@high">
										<xsl:attribute name="high">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_value">
										<xsl:attribute name="width_value">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_unit">
										<xsl:attribute name="width_unit">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</time>
							</xsl:for-each>
							<xsl:for-each select="signature">
								<signature/>
							</xsl:for-each>
						</dataEnterer>
					</xsl:for-each>
					<xsl:for-each select="nullifier">
						<nullifier>
							<xsl:for-each select="@comments">
								<xsl:attribute name="comments">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@practitionerParticipationType">
								<xsl:attribute name="practitionerParticipationType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@vpid">
								<xsl:attribute name="vpid">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="time">
								<time>
									<xsl:for-each select="@high">
										<xsl:attribute name="high">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@literal">
										<xsl:attribute name="literal">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@low">
										<xsl:attribute name="low">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_value">
										<xsl:attribute name="width_value">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@width_unit">
										<xsl:attribute name="width_unit">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</time>
							</xsl:for-each>
							<xsl:for-each select="signature">
								<signature/>
							</xsl:for-each>
						</nullifier>
					</xsl:for-each>
					<xsl:for-each select="patientState">
						<patientState>
							<xsl:for-each select="@rateAndConcentration">
								<xsl:attribute name="rateAndConcentration">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@ratePeriodValue">
								<xsl:attribute name="ratePeriodValue">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@ratePeriodUnit">
								<xsl:attribute name="ratePeriodUnit">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@rateHighValue">
								<xsl:attribute name="rateHighValue">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@rateLowValue">
								<xsl:attribute name="rateLowValue">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@concentrationHighValue">
								<xsl:attribute name="concentrationHighValue">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@concentrationLowValue">
								<xsl:attribute name="concentrationLowValue">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="patientStateType">
								<patientStateType>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</patientStateType>
							</xsl:for-each>
							<xsl:for-each select="rateHighCode">
								<rateHighCode>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</rateHighCode>
							</xsl:for-each>
							<xsl:for-each select="rateLowCode">
								<rateLowCode>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</rateLowCode>
							</xsl:for-each>
							<xsl:for-each select="concentrationHighCode">
								<concentrationHighCode>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</concentrationHighCode>
							</xsl:for-each>
							<xsl:for-each select="concentrationLowCode">
								<concentrationLowCode>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</concentrationLowCode>
							</xsl:for-each>
						</patientState>
					</xsl:for-each>
					<xsl:for-each select="device">
						<device>
							<xsl:for-each select="@deviceType">
								<xsl:attribute name="deviceType">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="@deviceName">
								<xsl:attribute name="deviceName">
									<xsl:value-of select="."/>
								</xsl:attribute>
							</xsl:for-each>
							<xsl:for-each select="id">
								<id>
									<xsl:for-each select="@assigningAuthorityName">
										<xsl:attribute name="assigningAuthorityName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@extension">
										<xsl:attribute name="extension">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@root">
										<xsl:attribute name="root">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</id>
							</xsl:for-each>
							<xsl:for-each select="software">
								<software>
									<xsl:for-each select="@codeSet">
										<xsl:attribute name="codeSet">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@code">
										<xsl:attribute name="code">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="@displayName">
										<xsl:attribute name="displayName">
											<xsl:value-of select="."/>
										</xsl:attribute>
									</xsl:for-each>
								</software>
							</xsl:for-each>
						</device>
					</xsl:for-each>
				</vitalSignObservationEvent>
			</xsl:for-each>
		</clinicalData>
	</xsl:template>
</xsl:stylesheet>
