

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.Element;

import java.util.List;


//wrapper for VdmVitalsBuilder
public class VitalSignObservationEventBuilderFactory
    implements
        ClinicalDomainBuilderFactoryInterface
{
    private VitalsBuilder vitalSignObservationEventBuilder = null;


    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildVitalsData( clinicalData, cnt, patientIdentifier );
    }


    private void buildVitalsData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );

        List<Element> vitalSignObservationEvents = vitalSignObservationEventBuilder.makeVitals( count, patientIdentifier );

        for ( Element vitalSignObservationEvent : vitalSignObservationEvents )
        {
            patient.add( vitalSignObservationEvent );
        }
    }


    public void setVitalSignObservationEventBuilder( VitalsBuilder vitalSignObservationEventBuilder )
    {
        this.vitalSignObservationEventBuilder = vitalSignObservationEventBuilder;
    }
}
