

package gov.va.med.cds.testharness.vhim400.builders;


import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class NonVaMedBuilder
    extends
        AbstractEntryPointBuilder
{
    public static final String[] DOCUMENTED_BYS = { "documented_by_1", "documented_by_2", "documented_by_3" };
    protected static Log logger = null;
    private static final String RECORD_VERSION = "12345";

    private int NME_IDX = 60000;


    public NonVaMedBuilder( )
    {
        super();
    }


    public NonVaMedBuilder( Random aRandom )
    {
        super( aRandom );
    }


    @Override
    public String fillPrintBuffer( Object object )
    {
        String returnString = "";

        if ( ( object != null ) && ( object instanceof Element ) )
        {
            returnString = ( ( Element )object ).asXML();
        }

        return returnString;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeNonVaMedicationEvent( personIdentifier );
    }


    public Element makeNonVaMedicationEvent( )
    {
        return makeNonVaMedicationEvent( null );
    }


    public List<Element> makeNonVaMedicationEvent( int number )
    {
        return makeNonVaMedicationEvents( number, null );
    }


    public Element makeNonVaMedicationEvent( Element patient )
    {
        Element newNonVaMedicationEvent = createNonVaMedicationEvent( NME_IDX++ , patient );

        return newNonVaMedicationEvent;
    }


    public Element makeNonVaMedicationEvents( String recordIdentifier, String recordStatus )
    {

        Element nonVaMedicationEvent = DocumentHelper.createElement( "nonVaMedicationEvent" );
        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
        nonVaMedicationEvent.add( newRecordIdentifier );

        nonVaMedicationEvent.addElement( "recordStatus" ).addText( recordStatus );

        return nonVaMedicationEvent;

    }


    public List<Element> makeNonVaMedicationEvents( int number, Element patient )
    {
        List<Element> newNonVaMedicationEvents = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            newNonVaMedicationEvents.add( makeNonVaMedicationEvent( patient ) );
        }

        return newNonVaMedicationEvents;
    }


    /*
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!--  NonVaMedicationEvent  <<all>>  -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <xsd:complexType name="NonVaMedicationEvent">
        <xsd:all>
            <xsd:element name="pharmacyPatient" type="common:PatientLite" minOccurs="0"/>
            <xsd:element name="dosage" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>
            <xsd:element name="route" type="basedatatypes:HL72CodedElementLite" minOccurs="0"/>
            <xsd:element name="schedule" type="xsd:string" minOccurs="0"/>
            <xsd:element name="status" type="xsd:string" minOccurs="0"/>
            <xsd:element name="discontinueDate" type="basedatatypes:PointInTime" minOccurs="0"/>
            <xsd:element name="orderIdentifier" type="basedatatypes:HL72EntityIdentifier" minOccurs="0"/>
            <xsd:element name="documentedBy" type="common:PractitionerParticipationLite" minOccurs="0"/>
            <xsd:element name="medication" type="common:Medicine" minOccurs="0"/>
            <xsd:element name="startDate" type="basedatatypes:PointInTime" minOccurs="0"/>
            <xsd:element name="orderLocationIdentifier" type="basedatatypes:HL72LocationIdentifier" minOccurs="0"/>
            <xsd:element name="comments" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="comment" type="xsd:string" minOccurs="0" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <xsd:element name="source" type="xsd:string" minOccurs="0"/>
            <xsd:element name="pharmacyOrderableItem" type="common:PharmacyOrderableItem" minOccurs="0"/>
            <xsd:element name="disclaimers" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="disclaimer" type="xsd:string" minOccurs="0" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <xsd:element name="detectedIssueEvents" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="detectedIssueEvent" type="pharmacy:DetectedIssueEvent" minOccurs="0" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <xsd:element name="recordSource" type="basedatatypes:HL72FacilityIdentifier" minOccurs="0"/>
            <xsd:element name="recordVersion" type="xsd:int" minOccurs="0"/>
            <xsd:element name="recordUpdateTime" type="basedatatypes:PointInTime" minOccurs="0"/>
            <xsd:element name="recordIdentifier" type="basedatatypes:HL72EntityIdentifier" minOccurs="0"/>
        </xsd:all>
    </xsd:complexType>
     */
    private Element createNonVaMedicationEvent( int id, Element patient )
    {
        Element element = DocumentHelper.createElement( "nonVaMedicationEvent" );

        element.add( createHL72EntityIdentifier( "recordIdentifier", id ) );

        Element newPatient = createPatientLite( "pharmacyPatient" );
        if ( patient != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patient.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( patient.elementText( "assigningFacility" ) );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( patient.elementText( "assigningAuthority" ) );
        }
        element.add( newPatient );

        element.add( createPhysicalQuantity( "dosage" ) );
        element.add( createHL72CodedElementLite( "route", "Route" ) );
        element.add( createHL72CodedElementLite( "schedule", "Schedule" ) );
        element.add( createHL72CodedElementLite( "status", "Status" ) );
        element.add( createFixedPointInTime( "discontinueDate" ) );
        element.add( createHL72EntityIdentifier( "orderIdentifier" ) );
        element.add( createPractitionerParticipationLite( "documentedBy", "comment", DOCUMENTED_BYS ) );

        Element newMedication = element.addElement( "medication" );
        //newMedication.add( createHL72CodedElementLite( "cmopDrugCode", "cmopDrugCode", "cmopDrugCode") );
        newMedication.add( createHL72CodedElement( "medicationCode", "medicationCode" ) );
        //newMedication.add( createHL72CodedElementLite( "otcCode", "otcCode", "otcCode") );
        //newMedication.add( createHL72CodedElementLite( "tradeName", "tradeName", "tradeName") );
        element.add( createFixedPointInTime( "startDate" ) );
        element.add( createHL72LocationIdentifier( "orderLocationIdentifier" ) );

        Element newComments = element.addElement( "comments" );
        newComments.addElement( "comment" ).setText( "comment" );
        newComments.addElement( "comment" ).setText( "comment" );

        element.addElement( "source" ).setText( "Source" );

        Element newPharmacyOrderableItem = element.addElement( "pharmacyOrderableItem" );
        newPharmacyOrderableItem.add( createHL72CodedElementLite( "itemCode", "ItemCode" ) );
        newPharmacyOrderableItem.add( createHL72CodedElementLite( "dosageFormCode", "DosageFormCode" ) );

        Element newDisclaimers = element.addElement( "disclaimers" );
        newDisclaimers.addElement( "disclaimer" ).setText( "disclaimer" );
        newDisclaimers.addElement( "disclaimer" ).setText( "disclaimer" );

        element.add( createDetectedIssueEvents( "detectedIssueEvents" ) );

        element.addElement( "recordVersion" ).setText( RECORD_VERSION );
        element.add( createFixedPointInTime( "recordUpdateTime" ) );

        return element;
    }


    /*
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!--  DetectedIssueEvent  <<all>>  -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <xsd:complexType name="DetectedIssueEvent">
        <xsd:all>
            <xsd:element name="id" type="basedatatypes:HL72EntityIdentifier" minOccurs="0"/>
            <xsd:element name="narrativeText" type="xsd:string" minOccurs="0"/>
            <xsd:element name="overridingProvider" type="common:PractitionerParticipationLite" minOccurs="0"/>
            <xsd:element name="detectedIssuesManagement" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="detectedIssueManagement" type="pharmacy:DetectedIssueManagement" minOccurs="0" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
        </xsd:all>
    </xsd:complexType>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!--  DetectedIssueManagement  <<all>>  -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <xsd:complexType name="DetectedIssueManagement">
        <xsd:all>
            <xsd:element name="overrideReason" type="xsd:string" minOccurs="0"/>
        </xsd:all>
    </xsd:complexType>
     */
    private Element createDetectedIssueEvents( String elementName )
    {
        Element detectedIssueEventsElement = DocumentHelper.createElement( elementName );
        Element element = detectedIssueEventsElement.addElement( "detectedIssueEvent" );

        element.add( createHL72EntityIdentifier( "id", "entityIdentifier", "namespaceId", "universalId" ) );
        element.addElement( "narrativeText" ).setText( "NarrativeText" );
        element.add( createPractitionerParticipationLite( "overridingProvider", "sourcePersonId", "comment" ) );
        Element newDetectedIssuesManagement = element.addElement( "detectedIssuesManagement" );
        //newDetectedIssuesManagement.addElement( "overrideReason" ).setText( "OverrideReason" );

        return detectedIssueEventsElement;
    }

}
