

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;


//wrapper for VdmSkillTrackingBuilder
public class HASkillTrackingBuilderFactory
    implements
        HATrackingClinicalDomainBuilderFactoryInterface
{
    private HASkillTrackingBuilder skillTrackingBuilder = null;


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        buildDomainData( clinicalData, cnt, patientIdentifier, null );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier, String skillType )
    {
        buildDomainData( clinicalData, cnt, patientIdentifier, skillType );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier, String goalName, String entryDate )
    {
        // this method required for GoalTracking
    }


    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildDomainData( clinicalData, recordIdentifier, recordStatus, null );
    }


    private void buildDomainData( Document clinicalData, String recordIdentifier, String recordStatus, String skillType )
    {

        Namespace xsiNS = DocumentHelper.createNamespace( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        Element rootElement = clinicalData.getRootElement();

        rootElement.add( xsiNS );

        Element patient = rootElement.element( "patient" );
        Element skillsTracking = skillTrackingBuilder.makeSkillTracking( "skillsTracking", recordIdentifier, recordStatus, "skillTracking", skillType );
        patient.add( skillsTracking );
    }


    private void buildDomainData( Document clinicalData, int count, Element patientIdentifier, String skillType )
    {
        Namespace xsiNS = DocumentHelper.createNamespace( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );

        //determine if we need a record identifier for an Update template else it will be excluded for a create xml 
        Element rootElement = clinicalData.getRootElement();
        rootElement.add( xsiNS );

        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;

        Element patient = rootElement.element( "patient" );
        Element skillTracking = skillTrackingBuilder.makeSkillTracking( patientIdentifier, count, updateRecordXml, skillType );
        patient.add( skillTracking );
    }


    public void setSkillTrackingBuilder( HASkillTrackingBuilder skillTrackingBuilder )
    {
        this.skillTrackingBuilder = skillTrackingBuilder;
    }


    public void setBuilder( AbstractEntryPointBuilder builder )
    {
        setSkillTrackingBuilder( ( HASkillTrackingBuilder )builder );
    }

}
