

package gov.va.med.cds.testharness.vhim400.builders;


import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;


public class HASkillTrackingBuilder
    extends
        AbstractEntryPointBuilder
{
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";

    private String recordIdentifier;
    private int IDX;

    public static final String[] CONTACT_METHODS = { "Method 1", "Method 2", "Method 3", "Method 4" };


    public HASkillTrackingBuilder( )
    {
        super();
    }


    public HASkillTrackingBuilder( String recordIdentifier, String personContacted )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HASkillTrackingBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HASkillTrackingBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makeSkillTracking( int number )
    {
        return makeSkillTracking( number, null );
    }


    public List<Element> makeSkillTracking( int number, Element patient )
    {
        return makeSkillTracking( number, patient, true, null );
    }


    public List<Element> makeSkillTracking( int number, Element patient, boolean updateRecordXml, String skillType )
    {
        List<Element> SkillTracking = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            SkillTracking.add( makeSkillTracking( "skillTracking", patient, updateRecordXml, skillType ) );
        }

        return SkillTracking;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeSkillTracking( "SkillTracking", personIdentifier, null );
    }


    public Element makeSkillTracking( String elementName, Element Identifier, String skillType )
    {
        return makeSkillTracking( elementName, Identifier, false, skillType );
    }


    public Element makeSkillTracking( String elementName, Element identifier, boolean updateRecordXml, String skillType )
    {
        IDX++ ;

        Element newSkillTracking = DocumentHelper.createElement( elementName );

        Element newPatient = createPatientLite( "patient" );
        if ( identifier != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( identifier.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( ASSIGNING_FACILITY_HDR );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( ASSIGNINGAUTHORITY_HDR );

        }

        newSkillTracking.add( newPatient );

        Element newEntryDateTime = createPointInTime( "entryDate", new Date() );
        newSkillTracking.add( newEntryDateTime );
        newSkillTracking.addElement( "skillSuccessLevel" ).addText( "0" );
        newSkillTracking.addElement( "skillType" ).addText( skillType );
        newSkillTracking.addElement( "skillFrequency" ).addText( "skillFrequency" );
        newSkillTracking.addElement( "dataEnterer" ).addText( "dataEnterer" );
        newSkillTracking.addElement( "allowAccessByClinicalStaff" ).addText( "true" );
        newSkillTracking.addElement( "comments" ).addText( "comments" );

        if ( updateRecordXml )
        {
            if ( this.recordIdentifier != null )
            {
                newSkillTracking.add( createHL72EntityIdentifier( "recordIdentifier", this.recordIdentifier ) );
            }
            else
            {
                newSkillTracking.add( createHL72EntityIdentifier( "recordIdentifier", IDX ) );
            }

        }
        return newSkillTracking;
    }


    public Element makeSkillTracking( Element identifier, int countObservations, boolean updateRecordXml, String skillType )
    {
        Element skillsTracking = DocumentHelper.createElement( "skillsTracking" );
        List<Element> skillTrackingList = makeSkillTracking( countObservations, identifier, updateRecordXml, skillType );
        for ( Element skillTracking : skillTrackingList )
        {
            skillsTracking.add( skillTracking );
        }

        return skillsTracking;
    }


    public Element makeSkillTracking( String outerElementName, String recordIdentifier, String recordStatus, String innerElementName, String skillType )
    {

        Element skillsTracking = DocumentHelper.createElement( outerElementName );
        Element skillTracking = DocumentHelper.createElement( innerElementName );
        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
        skillTracking.add( newRecordIdentifier );
        skillTracking.addElement( "recordStatus" ).addText( recordStatus );
        skillsTracking.add( skillTracking );

        return skillsTracking;

    }


    public String fillPrintBuffer( Object object )
    {
        String returnString = "";

        if ( ( object != null ) && ( object instanceof Element ) )
        {
            returnString = ( ( Element )object ).asXML();
        }

        return returnString;
    }
}
