package gov.va.med.cds.testharness.vhim400.builders;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class HAPatientEnteredMoodJournalEntryBuilderFactory implements HAClinicalDomainBuilderFactoryInterface
{
	private HAMoodJournalBuilder moodJournalBuilder = null;

	@Override
	public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) 
	{
		buildDomainData(clinicalData, cnt, patientIdentifier);
	}

	private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) 
	{
		 Namespace patientJournalingNS = DocumentHelper.createNamespace("patientjournaling", "PatientJournaling");
		Namespace xsiNS = DocumentHelper.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");

		// determine if we need a record identifier for an Update template else
		// it will be excluded for a create xml
		Element rootElement = clinicalData.getRootElement();
		rootElement.add(patientJournalingNS);
		rootElement.add(xsiNS);

		Element templateId = rootElement.element("templateId");
		boolean updateRecordXml = templateId.getText().endsWith("Update1") ? true : false;

		Element patient = rootElement.element("patient");
		Element patientJournalEntry = moodJournalBuilder.makeMoodJournalEntry( patientIdentifier, count, updateRecordXml);
		patient.add(patientJournalEntry);
	}
	
	private void buildDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        Namespace patientJournalingNS = DocumentHelper.createNamespace( "patientjournaling", "PatientJournaling" );
        Namespace xsiNS = DocumentHelper.createNamespace( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        Element rootElement = clinicalData.getRootElement();
        rootElement.add( patientJournalingNS );
        rootElement.add( xsiNS );

        Element patient = rootElement.element( "patient" );
        Element patientJournalEntries = moodJournalBuilder.makeJournalEntry( "patientJournalEntries", recordIdentifier, recordStatus, "patientjournaling:patientEnteredMoodJournalEntry" );
        patient.add( patientJournalEntries );
    }

	public void setMoodJournalBuilder(HAMoodJournalBuilder moodJournalBuilder) {
		this.moodJournalBuilder = moodJournalBuilder;
	}
	
	 public void setBuilder( AbstractEntryPointBuilder builder )
	 {    
	     setMoodJournalBuilder((HAMoodJournalBuilder)builder);
	 }


	@Override
	public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
		 buildDomainData( clinicalData, recordIdentifier, recordStatus );		
	}
	
	
}
