

package gov.va.med.cds.testharness.vhim400.builders;

import org.dom4j.Document;
import org.dom4j.Element;


public class HAPainReassessmentBuilderFactory
    implements
        HAClinicalDomainBuilderFactoryInterface
{
    private HAPainReassessmentBuilder painReassessmentBuilder = null;


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        buildDomainData( clinicalData, cnt, patientIdentifier );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildDomainData( clinicalData, recordIdentifier, recordStatus );
    }


    private void buildDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        Element patient = rootElement.element( "patient" );
        Element newPainReassessments = painReassessmentBuilder.makePainReassessment( "painReassessments", recordIdentifier, recordStatus );
        patient.add( newPainReassessments );
    }


    private void buildDomainData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;
        Element patient = rootElement.element( "patient" );
        Element newPainReassessments = painReassessmentBuilder.makePainReassessment( patientIdentifier, count, updateRecordXml );
        patient.add( newPainReassessments );
    }

    @Override
    public void setBuilder( AbstractEntryPointBuilder builder )
    {
        setPainReassessmentBuilder((HAPainReassessmentBuilder)builder);
    }


    public HAPainReassessmentBuilder getPainReassessmentBuilder( )
    {
        return painReassessmentBuilder;
    }


    public void setPainReassessmentBuilder( HAPainReassessmentBuilder painReassessmentBuilder )
    {
        this.painReassessmentBuilder = painReassessmentBuilder;
    }
}
