

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


public class HAExerciseJournalBuilder
    extends
        AbstractEntryPointBuilder
{
    private int IDX;
    private String recordIdentifier;
    private String physicalQty;

    private static final String[] ACTIVITY_TYPE = { "activityType1", "activityType2", "activityType3", "activityType4" };
    private static final String[] EXERCISE_INTENSITY = { "exerciseIntensity1", "exerciseIntensity2", "exerciseIntensity3", "exerciseIntensity4" };


    public HAExerciseJournalBuilder( )
    {
        super();
    }


    public HAExerciseJournalBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HAExerciseJournalBuilder( String recordIdentifier, String physicalQty )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.physicalQty = physicalQty;
    }


    public HAExerciseJournalBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makeJournalEntries( int number )
    {
        return makeJournalEntries( number, null );
    }


    public List<Element> makeJournalEntries( int number, Element patient )
    {
        return makeJournalEntries( number, patient, true );
    }


    public List<Element> makeJournalEntries( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> journalEntry = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            journalEntry.add( makeJournalEntry( "patientjournaling:patientEnteredExerciseJournalEntry", patient, updateRecordXml ) );
        }

        return journalEntry;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeJournalEntry( "patientjournaling:patientEnteredExerciseJournalEntry", personIdentifier );
    }


    public Element makeJournalEntry( String elementName, Element patientIdentifier )
    {
        return makeJournalEntry( elementName, patientIdentifier, false );
    }


    /*
    <xsd:complexType name="ExerciseJournalEntry">
        <xsd:complexContent>
            <xsd:extension base="patientjournaling:PatientJournalEntry">
                <xsd:all>
                    <xsd:element name="activityType" type="basedatatypes:HL72CodedElementLite" minOccurs="0"/>
                    <xsd:element name="exerciseIntensity" type="basedatatypes:HL72CodedElementLite" minOccurs="0"/>
                    <xsd:element name="activityDuration" type="basedatatypes:TimeQuantity" minOccurs="0"/>
                    <xsd:element name="activityDistance" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>
                    <xsd:element name="genericJournalEntryDetails" type="patientjournaling:BasicJournalEntry"/>
                </xsd:all>
            </xsd:extension>
        </xsd:complexContent>
    </xsd:complexType>

    <xsd:complexType name="BasicJournalEntry">
        <xsd:all>
            <xsd:element name="patient" type="common:PatientLite"/>
            <xsd:element name="journalEntryType" type="xsd:anyType"/>
            <xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true"/>
            <xsd:element name="comments" type="xsd:string" minOccurs="0"/>
            <xsd:element name="observationDate" type="basedatatypes:PointInTime"/>
            <xsd:element name="dataEnterer" type="xsd:string" minOccurs="0"/>
        </xsd:all>
    </xsd:complexType>
     */
    public Element makeJournalEntry( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newPatientJournalEntry = DocumentHelper.createElement( elementName );

        Element newActivityType = createHL72CodedElementLite( "activityType", "ActivityType", ACTIVITY_TYPE );
        newPatientJournalEntry.add( newActivityType );

        Element newExerciseIntensity = createHL72CodedElementLite( "exerciseIntensity", "ExerciseIntensity", EXERCISE_INTENSITY );
        newPatientJournalEntry.add( newExerciseIntensity );

        if ( this.physicalQty != null )
        {
            newPatientJournalEntry.add( createPhysicalQuantity( "activityDuration", this.physicalQty ) );
        }
        else
        {
            newPatientJournalEntry.add( createPhysicalQuantity( "activityDuration", "ActivityDuration" ) );
        }

        newPatientJournalEntry.add( createPhysicalQuantity( "activityDistance", "ActivityDistance" ) );

        if ( recordIdentifier != null )
        {
            newPatientJournalEntry.add( createGenericJournalEntryDetailsRecordId( "genericJournalEntryDetails", patientIdentifier, IDX,
                            updateRecordXml, recordIdentifier ) );
        }
        else
        {
            newPatientJournalEntry.add( createGenericJournalEntryDetails( "genericJournalEntryDetails", patientIdentifier, IDX, updateRecordXml ) );
        }
        return newPatientJournalEntry;
    }


    public Element makeExerciseJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element patientJournalEntries = DocumentHelper.createElement( "patientJournalEntries" );
        List<Element> patientJournalEntryList = makeJournalEntries( countObservations, patientIdentifier, updateRecordXml );
        for ( Element patientJournalEntry : patientJournalEntryList )
        {
            patientJournalEntries.add( patientJournalEntry );
        }

        return patientJournalEntries;
    }


    public String fillPrintBuffer( Object object )
    {
        String returnString = "";

        if ( ( object != null ) && ( object instanceof Element ) )
        {
            returnString = ( ( Element )object ).asXML();
        }

        return returnString;
    }

}
