

package gov.va.med.cds.testharness.vhim400.builders;


import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


public class HACalendarEventBuilder
    extends
        AbstractEntryPointBuilder
{
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";

    private String recordIdentifier;
    private String title;
    private String calendarEventStartDate;
    private int IDX;

    public HACalendarEventBuilder( )
    {
        super();
    }

    public HACalendarEventBuilder( String recordIdentifier, String title )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.title = title;
    }


    public HACalendarEventBuilder( String recordIdentifier, String title, String calendarEventStartDate )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.title = title;
        this.calendarEventStartDate = calendarEventStartDate;
    }


    public HACalendarEventBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HACalendarEventBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makeCalendarEvents( int number )
    {
        return makeCalendarEvents( number, null );
    }


    public List<Element> makeCalendarEvents( int number, Element patient )
    {
        return makeCalendarEvents( number, patient, true );
    }


    public List<Element> makeCalendarEvents( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> journalEntry = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            journalEntry.add( makeCalendarEvent( "calendarEvent", patient, updateRecordXml ) );
        }

        return journalEntry;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeCalendarEvent( "patientJournalEntry", personIdentifier );
    }


    public Element makeCalendarEvent( String elementName, Element patientIdentifier )
    {
        return makeCalendarEvent( elementName, patientIdentifier, false );
    }


    /*
        <xsd:element name="calendarEvents" minOccurs="0">
            <xsd:complexType>
                <xsd:sequence>
                       <xsd:element name="calendarEvent" type="patientjournaling:CalendarEvent"/>
                </xsd:sequence>
            </xsd:complexType>
        </xsd:element>
        <xsd:complexType name="CalendarEvent">
            <xsd:all>
                <xsd:element name="patient" type="common:PatientLite"/>
                <xsd:element name="calendarEventTitle" type="xsd:string" minOccurs="0"/>
                <xsd:element name="calendarEventStartDate" type="basedatatypes:PointInTime"/>
                <xsd:element name="calendarEventStopDate" type="basedatatypes:PointInTime" minOccurs="0"/>
                <xsd:element name="calendarEventReminderDateTime" type="basedatatypes:PointInTime" minOccurs="0"/>
                <xsd:element name="calendarEventNote" type="xsd:string" minOccurs="0"/>
                <xsd:element name="repeatFrequency" type="xsd:integer" minOccurs="0"/>
            </xsd:all>
        </xsd:complexType>
     */
    public Element makeCalendarEvent( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newCalendarEventEntry = DocumentHelper.createElement( elementName );

        Element newPatient = createPatientLite( "patient" );
        if ( patientIdentifier != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patientIdentifier.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( ASSIGNING_FACILITY_HDR );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( ASSIGNINGAUTHORITY_HDR );
        }

        newCalendarEventEntry.add( newPatient );

        if ( title != null )
            newCalendarEventEntry.addElement( "calendarEventTitle" ).addText( title );
        else
            newCalendarEventEntry.addElement( "calendarEventTitle" ).addText( "CalendarEventTitle" );

        Element newCalendarEventStartDate = ( this.calendarEventStartDate != null ) ? createPointInTime( "calendarEventStartDate", this.calendarEventStartDate )
                        : createFixedPointInTime( "calendarEventStartDate" );
        newCalendarEventEntry.add( newCalendarEventStartDate );

        Element newCalendarEventStopDate = createFixedPointInTime( "calendarEventStopDate" );
        newCalendarEventEntry.add( newCalendarEventStopDate );

        Element newCalendarEventReminderDateTime = createFixedPointInTime( "calendarEventReminderDateTime" );
        newCalendarEventEntry.add( newCalendarEventReminderDateTime );

        newCalendarEventEntry.addElement( "calendarEventNote" ).addText( "CalendarEventNote" );

        newCalendarEventEntry.addElement( "repeatFrequency" ).addText( "1" );

        if ( updateRecordXml )
        {
            if ( recordIdentifier != null )
            {
                Element element = DocumentHelper.createElement( "recordIdentifier" );
                element.addElement( "identity" ).addText( recordIdentifier );
                element.addElement( "namespaceId" ).addText( "NamespaceId" );
                element.addElement( "universalId" ).addText( "UniversalId" );
                element.addElement( "universalIdType" ).addText( "UniversalIdType" );
                newCalendarEventEntry.add( element );
            }
            else
            {
                Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", IDX );
                newCalendarEventEntry.add( newRecordIdentifier );
            }
        }

        return newCalendarEventEntry;
    }


    public Element makeCalendarEvent( String elementName, String recordIdentifier, String recordStatus )
    {
        Element newCalendarEvents = DocumentHelper.createElement( elementName );
        Element newCalendarEvent = DocumentHelper.createElement( "calendarEvent" );

        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
        newCalendarEvent.add( newRecordIdentifier );

        newCalendarEvent.addElement( "recordStatus" ).addText( recordStatus );
        newCalendarEvents.add( newCalendarEvent );

        return newCalendarEvents;
    }


    public Element makeCalendarEvent( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element newCalendarEvents = DocumentHelper.createElement( "calendarEvents" );
        List<Element> calendarEventList = makeCalendarEvents( countObservations, patientIdentifier, updateRecordXml );
        for ( Element calendarEvent : calendarEventList )
        {
            newCalendarEvents.add( calendarEvent );
        }

        return newCalendarEvents;
    }


    @Override
    public String fillPrintBuffer( Object aObject )
    {
        // TODO Auto-generated method stub
        return null;
    }

}
