/**
 * 
 */
package gov.va.med.cds.testharness.vhim400.builders;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class HAAssessmentDocumentBuilderFactory
    implements
    HAClinicalDomainBuilderFactoryInterface
{
    
    private HAAssessmentDocumentBuilder assessmentDocumentBuilder;
    
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildAssessmentDocumentData( clinicalData, cnt, patientIdentifier );
    }


    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildAssessmentDocumentData( clinicalData, recordIdentifier, recordStatus );
    }


    private void buildAssessmentDocumentData( Document clinicalData, int count, Element patientIdentifier )
    {
        //determine if we need a record identifier for an Update template else it will be excluded for a create xml 
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;

        Element patient = rootElement.element( "patient" );

        Element assessmentDocuments = assessmentDocumentBuilder.makeAssessmentDocuments(patientIdentifier, count, updateRecordXml );
       
        patient.add( assessmentDocuments );
    }


    private void buildAssessmentDocumentData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        //determine if we need a record identifier for an Update template else it will be excluded for a create xml 
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );

        Element patient = rootElement.element( "patient" );

        Element patientEnteredVitalSigns = assessmentDocumentBuilder.makeAssessmentDocuments( "assessmentDocuments",
                        recordIdentifier, recordStatus );

        patient.add( patientEnteredVitalSigns );
    }
    
    public void setAssessmentDocumentBuilder(HAAssessmentDocumentBuilder assessmentDocumentBuilder){
   
        this.assessmentDocumentBuilder = assessmentDocumentBuilder;
    }
          
    
    public void setBuilder( AbstractEntryPointBuilder builder )
    {
        this.setAssessmentDocumentBuilder((HAAssessmentDocumentBuilder) builder );
    }

}
