

package gov.va.med.cds.testharness.vhim400.builders;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration (locations = {"classpath:gov/va/med/cds/vdm/vhim400/dombuilders/buildersDomainEntryPointsContext.xml"})

public class CommonBuilderTest extends BuilderTest
{
    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreatePharmacyOrderableItem( )
    {
        printElementToSystemOut( CommonBuilder.createPharmacyOrderableItem( "defaultParmacyOrderable", "itemCodeCodePrefix", "dosageFormCodePrefix" ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreatePharmacyDivision( )
    {
        printElementToSystemOut(CommonBuilder.createPharmacyDivision("defaultParmacyDivision", "itemCodeCodePrefix", "ncdpidCodePrefix"));
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreatePractitionerLiteHL72PersonName( )
    {
        printElementToSystemOut( CommonBuilder.createPractitionerLite( "verifier", "familyName", "middleName", "prefix", "given", "suffix", "title" ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreatePractitionerLiteHL72PersonNameHL72PersonIdentifier( )
    {
        printElementToSystemOut( CommonBuilder.createPractitionerLite( "currentProvider", "familyName", "middleName", "prefix", "given", "suffix",
                        "title", "testIdentity", "testAssigningFacility", "testAssigningAuthority" ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreatePractitionerParticipationLite( )
    {
        printElementToSystemOut( CommonBuilder.createPractitionerParticipationLite( "author", "comment", "familyName", "middleName", "prefix",
                        "given", "suffix", "title", "identity", "assigningFacility", "assigningAuthority" ) );
    }

    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateClinicalDataPatientString( )
    {
    	printElementToSystemOut( CommonBuilder.createClinicalDataPatient("patient"));
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateClinicalDataPatientHL72PersonIdentifier( )
    {      
    	Element element = DocumentHelper.createElement("identifier");	
    	printElementToSystemOut( CommonBuilder.createClinicalDataPatient("patient", element));
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreatePatientLite( )
    {
    	printElementToSystemOut( CommonBuilder.createPatientLite("patient"));
    }
        
}
