

package gov.va.med.cds.testharness.vhim400.builders;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import java.util.Set;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/testharness/vhim400/builders/buildersTestContext.xml" } )
public class ClinicalDataDocumentBuilderTest
    extends
        BuilderTest
{
    @Autowired
    ClinicalDataBuilder clinicalDataBuilder;


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateEntryPointIntoleranceConditionRecord( )
    {
        printDocumentToSystemOut( clinicalDataBuilder.createClinicalData( TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateEntryPointAllergyAssessmentRecord( )
    {
        printDocumentToSystemOut( clinicalDataBuilder.createClinicalData( TemplateIdHelper.ALLERGY_ASSESSMENT_CREATEORUPDATE_TEMPLATE_ID ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateEntryPointLabRecord( )
    {
        printDocumentToSystemOut( clinicalDataBuilder.createClinicalData( TemplateIdHelper.LAB_CREATEORUPDATE_TEMPLATE_ID ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateEntryPointVitalsRecord( )
    {
        printDocumentToSystemOut( clinicalDataBuilder.createClinicalData( TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateEntryPointPharmacyRecord( )
    {
        printDocumentToSystemOut( clinicalDataBuilder.createClinicalData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateEntryPointTiuRecord( )
    {
        printDocumentToSystemOut( clinicalDataBuilder.createClinicalData( TemplateIdHelper.TIU_CREATEORUPDATE_TEMPLATE_ID ) );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testGetDomainEntryPoints( )
        throws Exception
    {
        // AllergyAssessmentCreate40020
        Set<DomainEntryPoint> entryPointsSet = clinicalDataBuilder.getDomainEntryPoints( TemplateIdHelper.ALLERGY_ASSESSMENT_CREATE_TEMPLATE_ID );
        Assert.assertTrue( entryPointsSet.contains( DomainEntryPoint.AllergyAssessment ) );
    }

}
