

package gov.va.med.cds.testharness.vhim400.builders;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;

import java.util.Map;
import java.util.Set;

import org.dom4j.Document;
import org.dom4j.Element;


public interface ClinicalDataBuilderInterface
    extends
        ClinicalDataResponseInterface
{
    public Map<String, ClinicalDomainBuilderFactoryInterface> getDomainEntryPointsWrappersMap( );


    public ClinicalDomainBuilderFactoryInterface getClinicalDomainBuildFactory( String domainEntryPoint );


    public Document createClinicalData( String templateId );


    public Document createClinicalData( String templateId, int cnt );


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int cnt );


    public Document createClinicalData( String templateId, String entityId );


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, String entityId );
    
    public Document createClinicalData( String templateId, int cnt, String entityId );


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int cnt, String entityId );


    public Document createClinicalData( String templateId, String templateSubstitutionKey, int cnt, Element patient );


    public Document createClinicalData( String templateId, int cnt, Element patient );//this method needs logic added in implementation
    //public ClinicalData createClinicalData( String templateId, int cnt, HL72PersonIdentifier aPatientId );


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int cnt, Element patient );//this method needs logic added in implementation
    //public ClinicalData createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int cnt, Element aPatientId ); //can't have duplicate - add logic to method above to determine if Elment is ClinicalData of a Patient


    public Document createClinicalData( String templateId, String templateSubstitutionKey, int count, Element patient, String skillType );


    public Document createClinicalData( String templateId, String templateSubstitutionKey, int count, Element patient, String goalName, String entryDate );


    public Document createClinicalData( String templateId, Element clinicalDataPatient );


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, Element clinicalDataPatient );


    public Document createClinicalData( DomainEntryPoint domainEntryPoint, int count );


    public Document createClinicalData( DomainEntryPoint domainEntryPoint, int count, Element patient );


    public Document updateClinicalData( String templateId, int count, Element patient );


    public Document deleteClinicalData( DomainEntryPoint domainEntryPoint, String templateId, Element patient, String recordIdentifier, String recordStatus );


    public Document deleteClinicalData( DomainEntryPoint domainEntryPoint, String templateId, String recordIdentifier, String recordStatus );


    void addAuditInfo( Element clinicaData, String clientName );
}
