

package gov.va.med.cds.testharness.vhim400.builders;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class BaseDatatypesBuilderTest extends BuilderTest
{

    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72CodedElementLite( )
    {
    	printElementToSystemOut( BaseDatatypesBuilder.createHL72CodedElementLite("reviewCode", "ReviewCode"));
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72CodedElementLiteElement( )
    {
    	Element element = BaseDatatypesBuilder.createHL72CodedElementLite("childCode", "ChildCode");
    	printElementToSystemOut( BaseDatatypesBuilder.createHL72CodedElementLite("masterCode", element));
    }


    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72CodedElement( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72CodedElement( "HL72CodedElement", "HL72CodedElement" ) );
    }


    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72CodedElementExtended( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72CodedElementExtended( "HL72CodedElementExtended", "HL72CodedElementExtended" ) );
    }


    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72LocationIdentifier( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72LocationIdentifier( "orderLocationIdentifier" ) );
        printElementToSystemOut( BaseDatatypesBuilder.createHL72LocationIdentifier( "orderLocationIdentifier", "SLC" ) );
    }


    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72OrganizationIdentifier( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72OrganizationIdentifier( "facilityIdentifier", "AssigningAuthNamespaceId",
                        "OrganizationId", "OrganizationName" ) );
    }


    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72OrganizationIdentifierExtended( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72OrganizationIdentifierExtended( "orderingFacilityIdentifier",
                        "AssigningAuthNamespaceId", "OrganizationId", "OrganizationName" ) );
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateMoney()
    {
        printElementToSystemOut( BaseDatatypesBuilder.createMoney("physcicianFees"));
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCeateHL7PersonName()
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL7PersonName("name"));
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72PersonIdentifier()
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72PersonIdentifier("identifier"));
    }
        
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateFixedPointInTime()
    {
        printElementToSystemOut( BaseDatatypesBuilder.createFixedPointInTime("fixed"));
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateUsMailingAddress()
    {
        printElementToSystemOut( BaseDatatypesBuilder.createUsMailingAddress("address"));
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreatePointInTime()
    {
        printElementToSystemOut( BaseDatatypesBuilder.createPointInTime("birthDate"));
    }
    
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72EntityIdentifier( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72EntityIdentifier("identifier"));
    }
 
    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testnameCreateFixedHL72EntityIdentifier( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createFixedHL72EntityIdentifier("identifier",1L));
    }

    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateHL72FacilityIdentifier( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createHL72FacilityIdentifier( "recordIdentifier" ) );
    }


    @Test
    @Suite(groups="prototypetest") // test used only to generate example xml for dev testing
    public void testCreateFixedHL72FacilityIdentifier( )
    {
        printElementToSystemOut( BaseDatatypesBuilder.createFixedHL72FacilityIdentifier("recordIdentifier",2L));
    }

}
