

package gov.va.med.cds.testharness.vhim400.builders;


import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class AllergyAssessmentBuilder
    extends
        AbstractEntryPointBuilder
{
    private static int ALLERGY_ASSESSMENT_IDX = 10000;
    private static final String[] AUTHOR_IDS = { "test_authorid_1001", "test_authorid_1002", "test_authorid_1003", "test_authorid_1004" };


    public AllergyAssessmentBuilder( )
    {
        super();
    }


    public AllergyAssessmentBuilder( Random aRandom )
    {
        super( aRandom );
    }


    public Element makeInsertAllergyAssessment( )
    {
        return makeAllergyAssessment();
    }


    public List<Element> makeInsertAllergyAssessments( int count )
    {
        List<Element> allergyAssessments = makeAllergyAssessments( count );

        return allergyAssessments;
    }


    public Element makeAllergyAssessment( )
    {
        return makeAllergyAssessment( null );
    }


    public List<Element> makeAllergyAssessments( int aNumber )
    {
        return makeAllergyAssessments( aNumber, null );
    }


    public Element makeAllergyAssessment( Element patient )
    {

        Element allergyAssessment = createAllergyAssessment( ALLERGY_ASSESSMENT_IDX++ , patient );

        return allergyAssessment;
    }


    public List<Element> makeAllergyAssessments( int number, Element patient )
    {
        List<Element> allergies = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            allergies.add( makeAllergyAssessment( patient ) );
        }

        return allergies;
    }


    public Element createEntryPointRecord( Element aPersonIdentifier )
    {
        return makeAllergyAssessment( aPersonIdentifier );
    }


    private Element createAllergyAssessment( int id, Element patient )
    {
        Element allergyAssessment = DocumentHelper.createElement( "allergyAssessments" );
        setAllergyAssessmentValues( allergyAssessment, id, patient );
        return allergyAssessment;
    }


    /*
    <xsd:complexType name="AllergyAssessment">
    <xsd:sequence>
      <xsd:element name="recordIdentifier" type="basedatatypes:HL72EntityIdentifier"/>
      <xsd:element name="patient" type="common:PatientLite"/>
      <xsd:element minOccurs="0" name="observationTime" type="basedatatypes:PointInTime"/>
      <xsd:element minOccurs="0" name="assessmentValue" type="basedatatypes:HL72CodedElementLite"/>
      <xsd:element minOccurs="0" name="status" type="xsd:string"/>
      <xsd:element minOccurs="0" name="author" type="common:PractitionerParticipationLite"/>
      <xsd:element minOccurs="0" name="recordSource" type="basedatatypes:HL72FacilityIdentifier"/>
      <xsd:element name="recordVersion" type="xsd:int"/>
      <xsd:element name="recordUpdateTime" type="basedatatypes:PointInTime"/>
    </xsd:sequence>
    </xsd:complexType>
    */
    @SuppressWarnings( "unchecked" )
    private void setAllergyAssessmentValues( Element allergyAssessment, int id, Element patient )
    {
        allergyAssessment.add( BaseDatatypesBuilder.createHL72EntityIdentifier( "recordIdentifier" ) );

        Element newPatient = createPatientLite( "patient" );
        if ( patient != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patient.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( patient.elementText( "assigningFacility" ) );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( patient.elementText( "assigningAuthority" ) );
        }

        allergyAssessment.add( newPatient );
        allergyAssessment.add( BaseDatatypesBuilder.createPointInTime( "observationTime" ) );
        allergyAssessment.add( BaseDatatypesBuilder.createHL72CodedElementLite( "assessmentValue", "codePrefix_?" ) );
        allergyAssessment.add( createSimpleStringElement( "status", "Status" ) );

        Element author = createPractitionerParticipationLite( "author", "Author Comment", AUTHOR_IDS );
        allergyAssessment.add( author );

        allergyAssessment.add( createHL72FacilityIdentifier( "recordSource" ) );
        allergyAssessment.add( createSimpleStringElement( "recordVersion", "1" ) );
        allergyAssessment.add( BaseDatatypesBuilder.createPointInTime( "recordUpdateTime" ) );

    }


    public void printAllergyAssessments( List<Element> listOfResults )
    {
        printDomainRecords( listOfResults );
    }


    public void printAllergyAssessments( List<Element> listOfResults, Logger aLogger )
    {
        printDomainRecords( listOfResults, aLogger );
    }


    public void printAllergyAssessment( Element allergy )
    {
        printDomainRecord( allergy );
    }


    public void printAllergyAssessment( Element allergy, Logger logger )
    {
        printDomainRecord( allergy, logger );
    }


    @Override
    public String fillPrintBuffer( Object object )
    {
        String returnString = "";

        if ( ( object != null ) && ( object instanceof Element ) )
        {
            returnString = ( ( Element )object ).asXML();
        }

        return returnString;
    }

}
