

package gov.va.med.cds.testharness.util;


import javax.xml.xpath.XPathExpressionException;


public interface XpathAsserterInterface
{

    /**
     * Compares the xpathExpression against two xml files
     * 
     * @param sourceXml source xml to compare
     * @param xpathExpression xpath expression to be run against sourceXml and controlXml
     * @param controlXml control xml to compare against
     * @throws XPathExpressionException
     */
    void assertXpathCompare( String sourceXml, String xpathExpression, String controlXml )
        throws XPathExpressionException;


    /**
     * @return the xpath object setup with correct namespaces
     */
    javax.xml.xpath.XPath getXpath( );

}
