

package gov.va.med.cds.testharness.sql;


/**
 * Provides connection strings for Oracle SqlPlus
 */
public class OracleSqlPlusConnectionStringBuilder
    implements
        ConnectionStringBuilderInterface
{
    private String username;
    private String password;
    private String host;
    private String port;
    private String ssid;


    /**
     * Sets the connection host
     * 
     * @param host
     */
    public void setHost( String host )
    {
        this.host = host;
    }


    /**
     * Sets the connection password
     * 
     * @param password
     */
    public void setPassword( String password )
    {
        this.password = password;
    }


    /**
     * Sets the connection port
     * 
     * @param port
     */
    public void setPort( String port )
    {
        this.port = port;
    }


    /**
     * Sets the Oracle connection ssid
     * 
     * @param ssid
     */
    public void setSsid( String ssid )
    {
        this.ssid = ssid;
    }


    /**
     * Sets the connection user name
     * 
     * @param username
     */
    public void setUsername( String username )
    {
        this.username = username;
    }


    /**
     * Creates an Oracle connection string from the class properties
     */
    public String toString( )
    {
        return username + "/" + password + "@" + host + ":" + port + "/" + ssid;
    }


    /**
     * @return Oracle connection string
     */
    public String getConnectionString( )
    {
        return toString();
    }
}
