

package gov.va.med.cds.testharness;


import gov.va.med.cds.properties.PropertiesUtil;

import org.apache.commons.logging.Log;
import org.apache.log4j.xml.DOMConfigurator;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.FactoryConfigurationError;


public class LoggingAndPropertyConfigurator
{
    private static final String LOGGER_CONFIG_PATH = "log4j.xml";
    private static final String APPLICATION_NAME = "CDS";


    public String getDefaultLoggingConfigFilePath( )
    {
        return LOGGER_CONFIG_PATH;
    }


    static public void configureLoggingAndProperties( Log logger, String logfilePath )
        throws FactoryConfigurationError,
            IOException
    {

        new PropertiesUtil().loadSystemRunProperties();

        // Setup logger
        if ( logfilePath == null )
            logfilePath = LOGGER_CONFIG_PATH;

        File logFile = new File( logfilePath );
        DOMConfigurator.configure( logFile.getAbsolutePath() );

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "using log file: "
                            + logFile.getAbsolutePath() ) );
        }
    }

}
