

package gov.va.med.cds.testharness;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;


/**
 * Re-factored to run with JUnit.
 * Used to be XMLUnit like abstraction for Test-NG based test harnesses. Use this class for strict XML comparison. If you need
 * relaxed order xml comparison then use the XmlComparitor tool.
 * 
 * By using this as a base the logging and property configuration is setup automatically to support multiple sand boxes.
 */
@RunWith(SuiteAwareRunner.class)
public abstract class AbstractXmlTest
    extends
        XMLTestCase
{
    protected static Log logger = null;
    private static String logfilePath = null;
    private static LoggingAndPropertyConfigurator configurator = null;
    private static final String APPLICATION_NAME = "CDS";


    protected AbstractXmlTest( String logfilePath )
    {
        this();
        this.logfilePath = logfilePath;
    }


    protected AbstractXmlTest( )
    {
        logger = LogFactory.getLog( getClass() );
    }


    /**
     * Delegates to the JUnit setUp Sets up the xerces parser for XMLUnit, configures log4j, loads system properties
     * 
     * @throws Exception
     */
    @BeforeClass
    public static void beforeAbstractXmlTestClassSetUp( )
        throws Exception
    {
        // Setup xml parser
        XMLUnit.setControlParser( "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl" );
        XMLUnit.setTestParser( "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl" );
        XMLUnit.setSAXParserFactory( "org.apache.xerces.jaxp.SAXParserFactoryImpl" );
        XMLUnit.setIgnoreWhitespace( true );

        configurator = new LoggingAndPropertyConfigurator(); 
        configurator.configureLoggingAndProperties( logger, logfilePath );

        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "just finished beforeAbstractXmlTestClassSetUp" ) );
    }


    /**
     * Delegates to the JUnit tearDown
     * 
     * @throws Exception
     */
    @AfterClass
    public static void afterAbstractXmlTestClassTearDown( )
        throws Exception
    {
        configurator = null;
        logfilePath = null;
    }
}
