

package gov.va.med.tfs.persistence;




import java.util.List;

import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;



/**
 * 
 */
public interface ReadPersistenceManagerInterface
    extends
        PersistenceManagerInterface
{

    /**
     * Handles the read requests.
     * 
     * @param aEntryFilter - persistence filter.
     * @param aPatients List of patients
     * @return List of CDM objects with each representing a single domain record and its chidren.
     * @throws PersistenceException
     */
    TemplateMetaData readTemplateData( String aTemplateId )
        throws Exception;

    
    List<String> readActiveTemplateIds( String vhimVersion )
    	throws Exception;

    List<String> readActiveFilterIds( String vhimVersion )
    	throws Exception;

    List<String> readVhimVersions( )
    	throws Exception;


    FilterMetaData readFilterData( String aFilterId )
        throws Exception;

}
