package gov.va.med.tfs;

import java.util.List;

import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;

import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;

/**
 * Service Endpoint Interface (SEI)
 *
 *
 */

@Remote	
@WebService		  
@SOAPBinding( style = Style.DOCUMENT, 
        use   = Use.LITERAL,
        parameterStyle = ParameterStyle.WRAPPED )
        
public interface TemplateFilterServiceInterface
{
    /**
     * Check to see if system is running
     *
     * @return true if the system is running.
     */
    @WebMethod
    boolean isAlive( );

    /**
     * @param vhimVersion the vhim version
     * @return array of template ids that are active for the version (not deprecated, inactive or ...)
     */
    @WebMethod
    List <String> getActiveTemplateIds( @WebParam( name = "vhimVersion" ) String vhimVersion );

    @WebMethod
    List <String> getActiveFilterIds( @WebParam( name = "vhimVersion" ) String vhimVersion );
    
    @WebMethod
    FilterMetaData getFilterMetaData( @WebParam( name = "filterId" ) String filterId );
    
    @WebMethod
    TemplateMetaData getTemplateMetaData( @WebParam( name = "templateId" ) String templateId );
    
    @WebMethod
    List<String> getVhimVersions( );
    
    @WebMethod
    String createTemplateMetaData( @WebParam( name = "templateMetaData" ) TemplateMetaData templateMetaData );
    
    @WebMethod
    String createFilterMetaData( @WebParam( name = "filterMetaData" ) FilterMetaData filterMetaData );
    
    @WebMethod
    String deleteFilterMetaData( @WebParam( name = "filterId" ) String filterId );
    
    @WebMethod
    String deleteTemplateMetaData( @WebParam( name = "templateId" ) String templateId );
    
}
