

package gov.va.med.tfs;


import java.util.List;

import gov.va.med.tfs.ejb.config.ServiceConstantsInterface;
import gov.va.med.tfs.persistence.CreateFilterPersistenceManagerInterface;
import gov.va.med.tfs.persistence.CreateTemplatePersistenceManagerInterface;
import gov.va.med.tfs.persistence.DeletePersistenceManagerInterface;
import gov.va.med.tfs.persistence.ReadPersistenceManagerInterface;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractStatelessSessionBean;


/**
 * Service Implementation Bean (SIB)
 *
 * HandlerChain - injects soap handler into framework
 * 
 * HandlerChain( file = "gov.va.med.tfs.config.soapHandler.xml" )
 * 
 */

@Stateless( mappedName="WTFService" )
//wsdlc generated "/wsdls/TemplateFilterServiceService.wsdl" 
@WebService( portName = "TemplateFilterServicePort", serviceName = "WTFService", targetNamespace = "http://tfs.domain.ext/", wsdlLocation = "wsdls/WTFService.wsdl", endpointInterface = "gov.va.med.tfs.TemplateFilterServiceInterface" )
@BindingType( "http://schemas.xmlsoap.org/wsdl/soap/http" )
public class TemplateFilterService
    extends
        AbstractStatelessSessionBean
    implements
        TemplateFilterServiceInterface,
        TemplateFilterServiceMBeanInterface

{

    public TemplateFilterService( )
    {
        super();
    }


    private static final long serialVersionUID = -1373224798187328078L;
    private Log logger = LogFactory.getLog( TemplateFilterService.class );
    private static ReadPersistenceManagerInterface readManager;
    private static CreateTemplatePersistenceManagerInterface createTemplateManager;
    private static CreateFilterPersistenceManagerInterface createFilterManager;
    private static DeletePersistenceManagerInterface deleteManager;
    private String SERVICE_EXCEPTION = "Service Exception Encountered: ";
    private String FUNCTION_DISABLED = "Requested Function is Not Enabled";
    private static boolean createEnabled;
    private static boolean deleteEnabled;


	public void init( )
    {
        logger.debug( "initializing the template filter service." );
    }


    public boolean isAlive( )
    {
        return true;
    }


    public List <String> getActiveTemplateIds( String vhimVersion )
    {
        System.out.println( "++++++++++ Entered getActiveTemplateIds with vhimVersion " + vhimVersion );
        logger.error( "++++++++++ Entered getActiveTemplateIds with vhimVersion " + vhimVersion );

        List <String> activeTemplateIds = null;

        try
        {
        	activeTemplateIds = readManager.readActiveTemplateIds( vhimVersion );
        }
        catch ( Exception e )
        {
            System.out.println( "++++++++++ getActiveTemplateIds Exception: " + e.getMessage() );
            logger.error( "++++++++++ getActiveTemplateIds Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        return activeTemplateIds;
    }


    public List <String> getActiveFilterIds( String vhimVersion )
    {
        System.out.println( "++++++++++ Entered getActiveFilterIds with vhimVersion " + vhimVersion );
        logger.error( "++++++++++ Entered getActiveFilterIds with vhimVersion " + vhimVersion );

        List <String> activeFilterIds = null;

        try
        {
        	activeFilterIds = readManager.readActiveFilterIds( vhimVersion );
        }
        catch ( Exception e )
        {
            System.out.println( "++++++++++ getActiveFilterIds Exception: " + e.getMessage() );
            logger.error( "++++++++++ getActiveFilterIds Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        return activeFilterIds;
    }

    public List<String> getVhimVersions( )
    {
    	System.out.println( "++++++++++ Entered getVhimVersions" );
        logger.error( "++++++++++ Entered getVhimVersions" );
        
        List<String> versions = null;
            try
            {
                versions = readManager.readVhimVersions();
            }
            catch ( Exception e )
            {
            	System.out.println( "++++++++++ getVhimVersions Exception: " + e.getMessage() );
                logger.error( "++++++++++ getVhimVersions Exception: " + e.getStackTrace() );
                e.printStackTrace();
            }
        return versions;
    }


    public FilterMetaData getFilterMetaData( String aFilterId )
    {
        System.out.println( "++++++++++ Entered getFilterMetaData with FilterId " + aFilterId );
        logger.error( "++++++++++ Entered getFilterMetaData with FilterId " + aFilterId );

        FilterMetaData filter = null;

        try
        {
            filter = readManager.readFilterData( aFilterId );
        }
        catch ( Exception e )
        {
            System.out.println( "++++++++++ getFilterMetaData Exception: " + e.getMessage() );
            logger.error( "++++++++++ getFilterMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        return filter;
    }


    public TemplateMetaData getTemplateMetaData( String aTemplateId )
    {
        System.out.println( "++++++++++ Entered getTemplateMetaData with TemplateId " + aTemplateId );
        logger.error( "++++++++++ Entered getTemplateMetaData with TemplateId " + aTemplateId );

        TemplateMetaData template = null;

        try
        {
            template = readManager.readTemplateData( aTemplateId );
        }
        catch ( Exception e )
        {
            System.out.println( "++++++++++ getTemplateMetaData Exception: " + e.getMessage() );
            logger.error( "++++++++++ getTemplateMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        return template;
    }
    
    
	public String createFilterMetaData( FilterMetaData aFilterMetaData ) 
	{
        System.out.println( "++++++++++ Entered createFilterMetaData with FilterId " + aFilterMetaData.getFilterId() );
        logger.error( "++++++++++ Entered createFilterMetaData with FilterId " + aFilterMetaData.getFilterId() );
        String returnPersist = null;
        
        if ( !(isCreateEnabled()) )
        {
        	return FUNCTION_DISABLED;
        }
        
        try 
        {
        	setFilterDerivedAttributes( aFilterMetaData );
        	returnPersist = createFilterManager.createFilterData( aFilterMetaData );
		} 
        catch (Exception e) 
		{
            System.out.println( "++++++++++ createFilterMetaData Exception: " + e.getMessage() );
            logger.error( "++++++++++ createFilterMetaData Exception: " + e.getStackTrace() );
			e.printStackTrace();
			returnPersist = SERVICE_EXCEPTION + e.getMessage();
		}
        
		return returnPersist;
	}


	private void setFilterDerivedAttributes( FilterMetaData aFilterMetaData ) 
	{
		aFilterMetaData.setDateAdded( new java.util.Date() );
	}


	public String createTemplateMetaData( TemplateMetaData aTemplateMetaData ) 
	{
        System.out.println( "++++++++++ Entered createTemplateMetaData with TemplateId " + aTemplateMetaData.getTemplateId() );
        logger.error( "++++++++++ Entered createTemplateMetaData with TemplateId " + aTemplateMetaData.getTemplateId() );
        String returnPersist = null;
        
        if ( !(isCreateEnabled()) )
        {
        	return FUNCTION_DISABLED;
        }
        
        try 
        {
        	setTemplateDerivedAttributes( aTemplateMetaData );
        	returnPersist = createTemplateManager.createTemplateData( aTemplateMetaData );
		} 
        catch (Exception e) 
		{
        	System.out.println( "++++++++++ createTemplateMetaData Exception: " + e.getMessage() );
            logger.error( "++++++++++ createTemplateMetaData Exception: " + e.getStackTrace() );
			e.printStackTrace();
			returnPersist = SERVICE_EXCEPTION + e.getMessage();
		}
        
		return returnPersist;
	}


    private void setTemplateDerivedAttributes( TemplateMetaData aTemplateMetaData ) 
    {
    	aTemplateMetaData.setDateAdded( new java.util.Date() );
	}
    
    
	public String deleteFilterMetaData(String aFilterId) 
	{
		System.out.println( "++++++++++ Entered deleteFilterMetaData with FilterId " + aFilterId );
        logger.error( "++++++++++ Entered deleteFilterMetaData with FilterId " + aFilterId );
        String returnDelete = null;
        
        if ( !(isDeleteEnabled()) )
        {
        	return FUNCTION_DISABLED;
        }
        
        try 
        {
        	returnDelete = deleteManager.deleteFilterData( aFilterId );
		} 
        catch (Exception e) 
		{
        	System.out.println( "++++++++++ deleteFilterMetaData Exception: " + e.getMessage() );
            logger.error( "++++++++++ deleteFilterMetaData Exception: " + e.getStackTrace() );
			e.printStackTrace();
			returnDelete = SERVICE_EXCEPTION + e.getMessage();
		}
        
		return returnDelete;
	}


	public String deleteTemplateMetaData(String aTemplateId) 
	{
		System.out.println( "++++++++++ Entered deleteTemplateMetaData with TemplateId " + aTemplateId );
        logger.error( "++++++++++ Entered deleteTemplateMetaData with TemplateId " + aTemplateId );
        String returnDelete = null;
        
        if ( !(isDeleteEnabled()) )
        {
        	return FUNCTION_DISABLED;
        }
        
        try 
        {
        	returnDelete = deleteManager.deleteTemplateData( aTemplateId );
		} 
        catch (Exception e) 
		{
        	System.out.println( "++++++++++ deleteTemplateMetaData Exception: " + e.getMessage() );
            logger.error( "++++++++++ deleteTemplateMetaData Exception: " + e.getStackTrace() );
			e.printStackTrace();
			returnDelete = SERVICE_EXCEPTION + e.getMessage();
		}
        
		return returnDelete;
	}


	@Override
    public void setSessionContext( SessionContext sessionContext )
    {
        System.out.println( "++++++++++ Entered setSessionContext" );
        logger.error( "++++++++++ Entered setSessionContext" );

        super.setSessionContext( sessionContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance( "tfsBeanRefContext.xml" ) );
        setBeanFactoryLocatorKey( ServiceConstantsInterface.PRIMARY_CONTEXT_ID );
    }
	
	
    @Override
    protected void onEjbCreate( )
        throws CreateException
    {
        System.out.println( "++++++++++ Entered onEjbCreate" );
        logger.error( "++++++++++ Entered onEjbCreate" );

        readManager = ( ReadPersistenceManagerInterface )getBeanFactory().getBean( "tfrReadable" );
        deleteManager = ( DeletePersistenceManagerInterface )getBeanFactory().getBean( "tfrDeletable" );
        createTemplateManager = ( CreateTemplatePersistenceManagerInterface )getBeanFactory().getBean( "tfrTemplateCreatable" );
        createFilterManager = ( CreateFilterPersistenceManagerInterface )getBeanFactory().getBean( "tfrFilterCreatable" );
    }
    
    public boolean isCreateEnabled() 
    {
    	System.out.println( "++++++++++ Entered isCreateEnabled: " + createEnabled);
		return createEnabled;
	}

    public void setCreateEnabled(boolean createEnabledSwitch) 
	{
		System.out.println( "++++++++++ Entered setCreateEnabled: " + createEnabled);
		createEnabled = createEnabledSwitch;
	}

    public boolean isDeleteEnabled() 
    {
    	System.out.println( "++++++++++ Entered isDeleteEnabled: " + deleteEnabled);
		return deleteEnabled;
	}

    public void setDeleteEnabled(boolean deleteEnabledSwitch) 
	{
		System.out.println( "++++++++++ Entered setDeleteEnabled: " + deleteEnabled);
		deleteEnabled = deleteEnabledSwitch;
	}
}
