# Script to remove iteration10 from jndi names for
# HDR2DataSource,HistoricalDataSource,ImsLoaderDataSource,ImsPsimCrossDomainDataSource,ImsPsimDodDomainDataSource,ImsPsimVaDomainDataSource,

from java import util
from java import io
from java.lang import String

runPropertiesPath = sys.argv[1]

properties = util.Properties();
filepath= java.lang.System.getenv("CDSN_HOME") + "/environments/properties/" + runPropertiesPath
fis = io.FileInputStream(io.File( filepath));
properties.load(fis);

connect(properties.getProperty("cds.appserver.admin.username"), properties.getProperty("cds.appserver.admin.password"), properties.getProperty("cds.appserver.admin.url"))

edit()
startEdit()

cd("/JDBCSystemResources/HDR2DataSource/JDBCResource/HDR2DataSource/JDBCDataSourceParams/HDR2DataSource")
jndiNames=jarray.zeros(1,String)
jndiNames[0] = properties.getProperty("cds.jdbc.dataSource.hdr2.jndiName")
set('JNDINames',jndiNames)

#reset HistoricalDataSource
cd("/JDBCSystemResources/HistoricalDataSource/JDBCResource/HistoricalDataSource/JDBCDataSourceParams/HistoricalDataSource")
jndiNames[0] = properties.getProperty("cds.hx.jdbc.dataSource.jndiName")
set('JNDINames',jndiNames)

#reset ImsLoaderDataSource
cd("/JDBCSystemResources/ImsLoaderDataSource/JDBCResource/ImsLoaderDataSource/JDBCDataSourceParams/ImsLoaderDataSource")
jndiNames[0] = properties.getProperty("cds.jdbc.dataSource.ims.loader.jndiName")
set('JNDINames',jndiNames)

#reset ImsPsimCrossDomainDataSource
cd("/JDBCSystemResources/ImsPsimCrossDomainDataSource/JDBCResource/ImsPsimCrossDomainDataSource/JDBCDataSourceParams/ImsPsimCrossDomainDataSource")
jndiNames[0] = properties.getProperty("cds.jdbc.dataSource.ims.x.jndiName")
set('JNDINames',jndiNames)

#reset ImsPsimDodDomainDataSource
cd("/JDBCSystemResources/ImsPsimDodDomainDataSource/JDBCResource/ImsPsimDodDomainDataSource/JDBCDataSourceParams/ImsPsimDodDomainDataSource")
jndiNames[0] = properties.getProperty("cds.jdbc.dataSource.ims.dod.jndiName")
set('JNDINames',jndiNames)

#reset ImsPsimVaDomainDataSource
cd("/JDBCSystemResources/ImsPsimVaDomainDataSource/JDBCResource/ImsPsimVaDomainDataSource/JDBCDataSourceParams/ImsPsimVaDomainDataSource")
jndiNames[0] = properties.getProperty("cds.jdbc.dataSource.ims.va.jndiName")
set('JNDINames',jndiNames)

#reset ImsQueuesDataSource; jdbcConfiguration.py uses hardcoded value for jndiname, so this script for now.
cd("/JDBCSystemResources/ImsQueuesDataSource/JDBCResource/ImsQueuesDataSource/JDBCDataSourceParams/ImsQueuesDataSource")
jndiNames[0] = "jdbc/gov/va/med/cds/hdrims/queues"
set('JNDINames',jndiNames)

save()
activate(block="true")
exit()
