package gov.va.med.tfs.junit.runners;

import java.util.List;
import java.lang.reflect.Method;
import org.junit.internal.runners.TestClass;;

public class RunnerUtils
{
    public static final int HIGH = Integer.MAX_VALUE;
    public static final int LOW = Integer.MIN_VALUE;
    public static final Class<AfterTestsOnce> AFTER_TESTS_ONCE = gov.va.med.tfs.junit.runners.AfterTestsOnce.class;
    public static final Class<BeforeTestsOnce> BEFORE_TESTS_ONCE = gov.va.med.tfs.junit.runners.BeforeTestsOnce.class;
    public static final Class<gov.va.med.tfs.junit.runners.Suite> MARKER_CLASS = gov.va.med.tfs.junit.runners.Suite.class;

    public static List<Method> getCustomaAnotatedMethods(TestClass testClass) {
        List <Method> customMethods = testClass.getAnnotatedMethods(BEFORE_TESTS_ONCE);
        customMethods.addAll( testClass.getAnnotatedMethods(AFTER_TESTS_ONCE));
        return customMethods;
    }
}
