package gov.va.med.tfs.client.webservice;

public class TemplateFilterServiceInterfaceProxy implements TemplateFilterServiceInterface {
  private String _endpoint = null;
  private TemplateFilterServiceInterface templateFilterServiceInterface = null;
  
  public TemplateFilterServiceInterfaceProxy() {
    _initTemplateFilterServiceInterfaceProxy();
  }
  
  public TemplateFilterServiceInterfaceProxy(String endpoint) {
    _endpoint = endpoint;
    _initTemplateFilterServiceInterfaceProxy();
  }
  
  private void _initTemplateFilterServiceInterfaceProxy() {
    try {
      templateFilterServiceInterface = (new WTFServiceLocator()).getTemplateFilterServicePort();
      if (templateFilterServiceInterface != null) {
        if (_endpoint != null)
          ((javax.xml.rpc.Stub)templateFilterServiceInterface)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);
        else
          _endpoint = (String)((javax.xml.rpc.Stub)templateFilterServiceInterface)._getProperty("javax.xml.rpc.service.endpoint.address");
      }
      
    }
    catch (javax.xml.rpc.ServiceException serviceException) {}
  }
  
  public String getEndpoint() {
    return _endpoint;
  }
  
  public void setEndpoint(String endpoint) {
    _endpoint = endpoint;
    if (templateFilterServiceInterface != null)
      ((javax.xml.rpc.Stub)templateFilterServiceInterface)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);
    
  }
  
  public TemplateFilterServiceInterface getTemplateFilterServiceInterface() {
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface;
  }
  
  public boolean isAlive() throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.isAlive();
  }
  
  public java.lang.String[] getActiveTemplateIds(java.lang.String vhimVersion) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.getActiveTemplateIds(vhimVersion);
  }
  
  public java.lang.String[] getActiveFilterIds(java.lang.String vhimVersion) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.getActiveFilterIds(vhimVersion);
  }
  
  public java.lang.String[] getVhimVersions() throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.getVhimVersions();
  }
  
  public FilterMetaData getFilterMetaData(java.lang.String filterId) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.getFilterMetaData(filterId);
  }
  
  public TemplateMetaData getTemplateMetaData(java.lang.String templateId) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.getTemplateMetaData(templateId);
  }
  
  public java.lang.String createFilterMetaData(FilterMetaData filterMetaData) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.createFilterMetaData(filterMetaData);
  }
  
  public java.lang.String createTemplateMetaData(TemplateMetaData templateMetaData) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.createTemplateMetaData(templateMetaData);
  }
  
  public java.lang.String deleteFilterMetaData(java.lang.String filterId) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.deleteFilterMetaData(filterId);
  }
  
  public java.lang.String deleteTemplateMetaData(java.lang.String templateId) throws java.rmi.RemoteException{
    if (templateFilterServiceInterface == null)
      _initTemplateFilterServiceInterfaceProxy();
    return templateFilterServiceInterface.deleteTemplateMetaData(templateId);
  }
  
  
}