/**
 * 
 */


package gov.va.med.tfs.client;

import gov.va.med.cds.registry.JAXRUtility;
import gov.va.med.tfs.client.webservice.TemplateFilterServiceInterface;
import gov.va.med.tfs.client.webservice.TemplateFilterServicePortBindingStub;
import gov.va.med.tfs.client.webservice.WTFServiceLocator;
import gov.va.med.tfs.exception.WtfServiceCreateException;

import java.net.URL;

import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Service;
import javax.xml.rpc.ServiceException;

public class TfsServiceFactory
{
	private String serviceBindingId = null;

	private JAXRUtility jaxrHelper = null;
    

    public synchronized TemplateFilterServiceInterface create( Integer tfsWebserviceTimeoutSecs )
    {
        try
        {
        	
            return getBusinessDelegate(tfsWebserviceTimeoutSecs);
        }
        catch ( Exception ex )
        {
            throw new WtfServiceCreateException( "Could not create TAFS web service client.", ex );
        }
    }
    
    private TemplateFilterServiceInterface getBusinessDelegate(Integer tfsWebserviceTimeoutSecs) throws ServiceException {
		try {

			Service service = (Service) jaxrHelper.findByIdAndType(
					serviceBindingId, LifeCycleManager.SERVICE);
			URL endpoint = jaxrHelper.serviceToServiceEndpointURL(service);

			WTFServiceLocator wtfWsLocator = new WTFServiceLocator();
			wtfWsLocator.setEndpointAddress(new javax.xml.namespace.QName("http://tfs.domain.ext/", "TemplateFilterServicePort"),
					endpoint.toString());
			
			TemplateFilterServicePortBindingStub port = (TemplateFilterServicePortBindingStub)wtfWsLocator.getTemplateFilterServicePort();

			if (tfsWebserviceTimeoutSecs != null) {
				port.setTimeout(tfsWebserviceTimeoutSecs * 1000);
			}
			return port;

		} catch (Exception e) {
			throw new ServiceException("Error finding service in registry.", e);
		}
	}
    
    public void setServiceBindingId(String serviceBindingId) {
		this.serviceBindingId = serviceBindingId;
	}

    public void setJaxrHelper(JAXRUtility jaxrHelper) {
		this.jaxrHelper = jaxrHelper;
	}
}
