

package gov.va.med.cds.socket.server.handler;


import static org.junit.Assert.assertNotNull;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class AccessValidatorExceptionTest
{
    private static ErrorCodeEnum errorCode = ErrorCodeEnum.ACCESSOR_ENTRYPOINT_INVALID;
    private static Throwable cause = new Throwable( "currentException" );
    private static String ourStrings[] = { "abcd", "efgh", "ijkl" };


    @Test
    @Suite(groups = "checkintest")
    public void testAccessValidatorExceptionTest1( )
    {
        try
        {
            throw new AccessValidatorException( errorCode, cause, ourStrings );
        }
        catch ( AccessValidatorException cx )
        {
            assertNotNull( cx );
        }
    }


    @Test
    @Suite(groups = "checkintest")
    public void testAccessValidatorExceptionTest2( )
    {
        try
        {
            throw new AccessValidatorException( errorCode, ourStrings );
        }
        catch ( AccessValidatorException cx )
        {
            assertNotNull( cx );
        }
    }


    @Test
    @Suite(groups = "checkintest")
    public void testAccessValidatorExceptionTest3( )
    {
        try
        {
            throw new AccessValidatorException( errorCode );
        }
        catch ( AccessValidatorException cx )
        {
            assertNotNull( cx );
        }
    }


    @Test
    @Suite(groups = "checkintest")
    public void testAccessValidatorExceptionTest4( )
    {
        try
        {
            throw new AccessValidatorException( errorCode, cause );
        }
        catch ( AccessValidatorException cx )
        {
            assertNotNull( cx );
        }
    }
}
