/**
 * 
 */


package gov.va.med.cds.socket.server;


import static org.junit.Assert.*;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.testharness.AbstractBaseTest;

import java.io.IOException;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.xsocket.connection.BlockingConnection;
import org.xsocket.connection.IBlockingConnection;


/**
 * @author vhaislegberb
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/socket/server/socketAdapterServerManagerContext.xml" } )
public class SocketAdapterServerManagerTest
    extends
        AbstractBaseTest
{
    private ServerManager serverManager;


    /**
     * Tests that the server manager has started the servers and that the
     * configured data handler is receiving the request.
     */
    @Test
    @Suite( groups = "checkintest", order = 1 )
    public void testServerManagerEchoHello( )
        throws Exception
    {
        IBlockingConnection blockingConnection = null;

        try
        {
            blockingConnection = new BlockingConnection( "localhost", 5001 );
            int written = blockingConnection.write( "Hello\r\n" );
            assertTrue( written == 7 );

            blockingConnection.flush();

            String read = blockingConnection.readStringByDelimiter( "\r\n" );
            assertTrue( read.equals( "Echo: Hello" ) );
        }
        finally
        {
            if ( blockingConnection != null )
            {
                blockingConnection.close();
            }
        }

    }


    /**
     * Tests that the server manager has started the servers and that the
     * configured data handler is receiving the request.
     */
    @Test( expected = IOException.class )
    @Suite( groups = "checkintest", order = 2 )
    public void testServerManagerStopServers( )
        throws Exception
    {
        // shutdown the servers
        this.serverManager.stopServers();

        // now try to make a connection to the server.
        IBlockingConnection blockingConnection = null;

        try
        {
            // this should cause an IO Exception to occur
            blockingConnection = new BlockingConnection( "localhost", 5001 );
            int written = blockingConnection.write( "Hello\r\n" );

            assertTrue( written == 7 );
            blockingConnection.flush();

            String read = blockingConnection.readStringByDelimiter( "\r\n" );
            assertTrue( read.equals( "Echo: Hello" ) );
        }
        finally
        {
            if ( blockingConnection != null )
            {
                blockingConnection.close();
            }
        }

    }


    @Resource
    public void setServerManager( ServerManager serverManager )
    {
        this.serverManager = serverManager;
    }

}
