/**
 * 
 */


package gov.va.med.cds.aspects.exception;


import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.socket.server.handler.AccessValidatorException;
import gov.va.med.cds.socket.server.handler.AccessValidatorInterface;
import gov.va.med.cds.testharness.AbstractBaseTest;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


/**
 * @author susarlan
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "file:src/test/resources/config/exception/test-log-and-rethrow-context.xml",
                "file:src/test/resources/mllpAccessValidatorSpringContext.xml" } )
public class AdapterLogAndRethrowAspectTest
    extends
        AbstractBaseTest
{
    private AccessValidatorInterface mllpAccessValidator;


    /***
     * Logs ans swallows the exception thrown when the response contains an
     * error section
     * 
     * @throws Exception
     */
    //Test not run in CDS 2.x build   @Test( expected = AccessValidatorException.class )
    @Test
    public void testLogAndRethrow( )
        throws Exception
    {
        String hl7Request = "MSH^~|\\&^CHDR SENDER^HDR^VHA_HDR^INVALID_FACILITY^20080620150649.582-0400~D^^QBP~Z99~QRY_Q01^1213988809582^T^2.4\n";
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
        mllpAccessValidator.validateAccess( hl7Support );
    }


    @Resource
    public void setMllpAccessValidator( AccessValidatorInterface mllpAccessValidator )
    {
        this.mllpAccessValidator = mllpAccessValidator;
    }


    @BeforeClass
    public static void setUp( )
        throws Exception
    {

    }


    @AfterClass
    public static void tearDown( )
        throws Exception
    {

    }
}
