

package gov.va.med.cds.socket.server;


import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.INonBlockingConnection;
import java.io.IOException;
import java.nio.BufferUnderflowException;


public class SimpleEchoDataHandler
    implements
        IDataHandler

{

    public boolean onData( INonBlockingConnection connection )
        throws IOException,
            BufferUnderflowException,
            MaxReadSizeExceededException
    {
        String echo = connection.readStringByDelimiter( "\r\n" );
        connection.write( String.format( "Echo: %s\r\n", echo ) );
        connection.flush();
        
        return true;
    }

}
