

package gov.va.med.cds.ejb;


import gov.va.med.cds.ejb.config.SynchronousMessageBeanConstantsInterface;
import gov.va.med.mediator.client.messagemediator.MessageMediatorInterface;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractStatelessSessionBean;

@WebService(serviceName="MessageMediatorServiceInterface", 
            targetNamespace="http://messagemediator.client.mediator.domain.ext", 
            portName="MessageMediatorInterfaceHttpPort",
            endpointInterface = "gov.va.med.mediator.client.messagemediator.MessageMediatorInterface")
public class SynchronousMessageBean
    extends
        AbstractStatelessSessionBean
    implements
        MessageMediatorInterface
{

    private static final long serialVersionUID = -4789139550723053300L;
    private MessageMediatorInterface messageMediator;

    @Override
    @WebMethod(exclude=true)
    protected void onEjbCreate( )
        throws CreateException
    {
        messageMediator = ( MessageMediatorInterface )getBeanFactory().getBean( "messageMediator" );

    }


    /**
     * Override default BeanFactoryLocator implementation
     * 
     * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
     */
    @Override
    @WebMethod(exclude=true)
    public void setSessionContext( SessionContext sessionContext )
    {
        super.setSessionContext( sessionContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance("momBeanRefContext.xml") );
        setBeanFactoryLocatorKey( SynchronousMessageBeanConstantsInterface.PRIMARY_CONTEXT_ID );
    }


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#isAlive()
     */
    @WebMethod(operationName="isAlive")
    public @WebResult(name="out")boolean isAlive( )
    {
        return messageMediator.isAlive();
    }


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#processMessage(java.lang.String)
     */
    @WebMethod(operationName="processMessage")
    public @WebResult(name="out")String processMessage( @WebParam(name="in0")String hl7MessageRequest )
    {
        return messageMediator.processMessage( hl7MessageRequest );
    }
    
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#processMessage(java.lang.String, java.lang.Boolean)
     */
    @WebMethod(operationName="processMessage1")
    public @WebResult(name="out")String processMessage( @WebParam(name="in0")String hl7MessageRequest, @WebParam(name="in1")Boolean persistOriginalMessage )
    {
        return messageMediator.processMessage( hl7MessageRequest, persistOriginalMessage );
    }

}
