from java import util
from java import io
from java.lang import String

def undeployMediatorEnterpriseApp(mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppAdminUrl):
    connect(mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppAdminUrl)
    cd("AppDeployments")
    for i in ls().split() : 
        if( i.count('mediator-ear') > 0 ) :
            undeploy(i)
    disconnect()
# end undeployMediatorEnterpriseApp()

def doBounceWeblogic(mediatorAppAdminUrl, mediatorAppDomainName, mediatorNodeMgrPort, mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppTargetServer, mediatorAppDomainDir, applicationName, applicationFilePath):
    print 'Bouncing Weblogic Server'
    
    hostNameStartIndex=String(mediatorAppAdminUrl).indexOf("//")
    hostNameStopIndex=String(mediatorAppAdminUrl).indexOf(":",hostNameStartIndex)
    hostName=String(mediatorAppAdminUrl).substring(hostNameStartIndex+2,hostNameStopIndex)
    
    if (mediatorAppTargetServer != (mediatorAppDomainName+'.admin')): 
      '''SHUTDOWN Managed Servers'''

      nmPort=mediatorNodeMgrPort
      if nmPort is None:
      	nmPort='5559'

      nmConnect(mediatorAppAdminUsername, mediatorAppAdminPwd, hostName, nmPort, mediatorAppDomainName)
      
      nmKill(mediatorAppTargetServer) 
      nmStart(mediatorAppTargetServer)    
    
      nmDisconnect();
    else: 
      '''SHUTDOWN and RESTART Admin Server, if Admin Server is the Target'''
      shutdown(mediatorAppDomainName+'.admin','Server')
      startServer(mediatorAppTargetServer, mediatorAppDomainName, mediatorAppAdminUrl, mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppDomainDir)
#end bounceWeblogic()
    
def deployMediatorEnterpriseApp(mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppAdminUrl):
    connect(mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppAdminUrl)
    cd("AppDeployments")
    deploy(applicationName, applicationFilePath, mediatorAppTargetServer, upload='true')
    startApplication(applicationName)
    disconnect()
#end deployMediatorEnterpriseApp()

#runPropertiesPath = sys.argv[1]
bounceWeblogic = sys.argv[1]
applicationName = sys.argv[2]
applicationFilePath = sys.argv[3]
mediatorAppAdminUsername = sys.argv[4]
mediatorAppAdminPwd = sys.argv[5]
mediatorAppAdminUrl = sys.argv[6]
mediatorAppTargetServer = sys.argv[7]
mediatorAppDomainName = sys.argv[8]
mediatorNodeMgrPort = sys.argv[9]
mediatorAppDomainDir = sys.argv[10]

#props = util.Properties();
#fis = io.FileInputStream(io.File(runPropertiesPath));
#props.load(fis);

# undeploy any CDS EAR that is currently deployed.
undeployMediatorEnterpriseApp(mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppAdminUrl)

# bounce the server if requested
if(bounceWeblogic == 'True'):
    doBounceWeblogic(mediatorAppAdminUrl, mediatorAppDomainName, mediatorNodeMgrPort, mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppTargetServer, mediatorAppDomainDir, applicationName, applicationFilePath)

# deploy the CDS EAR to the target server.
deployMediatorEnterpriseApp(mediatorAppAdminUsername, mediatorAppAdminPwd, mediatorAppAdminUrl)

exit()