

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.hapi.HL7SupportException;
import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class Er7toXmlTranslationTest
    extends
        AbstractBaseTest
{
    private static Log logger = LogFactory.getLog( Er7toXmlTranslationTest.class );


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testVitalsHomeTeleHealthErltoHlXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/er7WithErrors/hth.er7" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testAllergyIntoleranceConditionErltoHlXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/er7WithErrors/algy.er7" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testAllergyAssessmentConditionErltoHlXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/er7WithErrors/algyasst.er7" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testVitalsErltoHlXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/er7WithErrors/vitals.er7" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testPharmacyPartialErltoHlXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/er7WithErrors/phmcypartial.er7" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLabEr7toHapiXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/hl7-er7/hdrlab_cds_data.txt" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void test2LabEr7toHapiXmlConvertion( )
        throws FileNotFoundException,
            IOException
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( StreamUtil.streamAsString( new FileReader(
                        "./src/test/resources/hl7-er7/hdrlab_cds_data2.txt" ) ) );
        String result = hl7Support.toXml();
        logger.debug( result );
    }
}
