

package gov.va.med.cds.mediator.work.hapi;


import java.util.Map;
import java.util.Set;


public class Er7MessageUtil
{
    public static final String MESSAGE_CONTROL_ID = "{MESSAGE-CONTROL-ID}";
    public static final String REQUEST_MESSAGE_CONTROL_ID = "{REQUEST-MESSAGE-CONTROL-ID}";
    public static final String MESSAGE_DATE_TIME = "{MESSAGE-DATE-TIME}";


    public static String replaceMessageControlId( String responseMessage, String messageControlId )
    {
        if ( responseMessage == null || messageControlId == null )
        {
            return responseMessage;
        }
        return responseMessage.replace( MESSAGE_CONTROL_ID, messageControlId );

    }


    public static String replaceRequestMessageControlId( String responseMessage, String requestMessageControlId )
    {
        if ( responseMessage == null || requestMessageControlId == null )
        {
            return responseMessage;
        }
        return responseMessage.replace( REQUEST_MESSAGE_CONTROL_ID, requestMessageControlId );

    }


    public static String replaceMessageDateTime( String responseMessage, String dateTime )
    {
        if ( responseMessage == null || dateTime == null )
        {
            return responseMessage;
        }
        return responseMessage.replace( MESSAGE_DATE_TIME, dateTime );

    }


    public static String replaceValues( String responseMessage, Map<String, String> replacementAndValues )
    {
        Set<String> replaceMents = replacementAndValues.keySet();
        for ( Object key : replaceMents )
        {
            responseMessage = responseMessage.replace( key.toString(), replacementAndValues.get( key ) );
        }

        return responseMessage;

    }

}
