

package gov.va.med.cds.mediator.work.cds;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.mediator.work.MapBackedWorkState;
import gov.va.med.cds.mediator.work.WorkStateException;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import java.io.IOException;

import javax.annotation.Resource;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class ClinicalDataCreateMessageProcessorTest
    extends
        AbstractBaseTest
{

    private ClinicalDataCreateMessageWork clinicalDataCreateMessageWork;


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testClinicalDataCreateMessageWorkNoHL7Support( )
        throws IOException
    {
        String vhimRequest = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hl7-vhim/expected/hdrpres-vista-full.xml" ) );

        // create the mock object to use for the test.
        ClinicalDataServiceInterface cdsSynchronous = ( ClinicalDataServiceInterface )EasyMock
                        .createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsSynchronous.createClinicalData( vhimRequest, "PharmacyCreateOrUpdate40060", "55253801873"/*,  false */ ) ) // TODO: Need to modify CDS client interface to support audit flag.  
                        .andReturn( "SUCCESS" );
        EasyMock.replay( cdsSynchronous );

        clinicalDataCreateMessageWork.setCdsSynchronous( cdsSynchronous );

        WorkStateInterface workState = new MapBackedWorkState();
        workState.registerWorkState( "VHIM-REQUEST", vhimRequest );

        clinicalDataCreateMessageWork.doWork( workState );

        String workStateResponse = ( String )workState.locateWorkState( "OUTPUT-MESSAGE" );
        assertEquals( workStateResponse, "SUCCESS" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testClinicalDataCreateMessageWork( )
        throws Exception
    {
        String request = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hl7-er7/hdrpres-vista-full.txt" ) );
        String vhimRequest = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hl7-vhim/expected/hdrpres-vista-full.xml" ) );

        // create the mock object to use for the test.
        ClinicalDataServiceInterface cdsSynchronous = ( ClinicalDataServiceInterface )EasyMock
                        .createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsSynchronous.createClinicalData( vhimRequest, "PharmacyCreateOrUpdate40060", "55253801873" /*, false */ ) ) // TODO: Need to modify CDS client interface to support audit flag.
                        .andReturn( "SUCCESS" );
        EasyMock.replay( cdsSynchronous );

        clinicalDataCreateMessageWork.setCdsSynchronous( cdsSynchronous );

        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( request );

        WorkStateInterface workState = new MapBackedWorkState();
        workState.registerWorkState( "HL7-SUPPORT", hl7Support );
        workState.registerWorkState( "VHIM-REQUEST", vhimRequest );

        clinicalDataCreateMessageWork.doWork( workState );

        String workStateResponse = ( String )workState.locateWorkState( "OUTPUT-MESSAGE" );
        assertEquals( workStateResponse, "SUCCESS" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testClinicalDataCreateMessageWorkNotPersisted( )
        throws Exception
    {
        WorkStateInterface workState = new MapBackedWorkState();
        workState.registerWorkState( "AUDIT_CLOB_NOT_PERSISTED", true );

        clinicalDataCreateMessageWork.doWork( workState );

        String workStateResponse = ( String )workState.locateWorkState( "OUTPUT-MESSAGE" );
        assertEquals( workStateResponse, "Failure Persisting Audit Clob Store - Message was not sent to CDS for processing." );
    }


    @Resource
    public void setClinicalDataCreateMessageWork( ClinicalDataCreateMessageWork clinicalDataCreateMessageWork )
    {
        this.clinicalDataCreateMessageWork = clinicalDataCreateMessageWork;
    }

}
