

package gov.va.med.cds.mediator;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;

import java.io.IOException;

import org.easymock.EasyMock;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;


@RunWith( SuiteAwareRunner.class )
public class MessageMediatorTest
{
    private static ResourceLoader resourceLoader = null;
    private static Resource resource = null;


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeClassSetup( )
        throws Exception
    {
        resourceLoader = new DefaultResourceLoader();
        resource = resourceLoader.getResource( "file:src/test/resources/hl7-er7/hdradas-full.txt" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void isAliveTest( )
    {
        assertTrue(new MessageMediator().isAlive());
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void processMessageTest( )
        throws IOException
    {
        Resource mockResource = resourceLoader.getResource( "file:src/test/resources/hl7-vhim/expected/expectedResult.xml" );
        String mockStringResource = StreamUtil.resourceToString( mockResource );

        String hl7MessageRequest = StreamUtil.resourceToString( resource );

        MessageProcessorInterface messageProcessorInterfaceMock = EasyMock.createMock( MessageProcessorInterface.class );
        EasyMock.expect( messageProcessorInterfaceMock.processMessage( hl7MessageRequest, false ) ).andReturn( mockStringResource );
        EasyMock.replay( messageProcessorInterfaceMock );
        
        MessageMediator messageMediator = new MessageMediator();
        messageMediator.setMessageProcessor( messageProcessorInterfaceMock );
        String result = messageMediator.processMessage( hl7MessageRequest );
        assertEquals(result, mockStringResource);
    }
}
