/**
 * 
 */


package gov.va.med.cds.client.proxy;


import gov.va.med.cds.exception.SocketClientException;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.AbstractLoggingTest;

import java.io.IOException;
import java.net.SocketTimeoutException;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IBlockingConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.Server;


/**
 * @author susarlan
 * 
 */
@RunWith( SuiteAwareRunner.class )
public class BlockingConnectionFactoryTest
    extends
        AbstractLoggingTest
{
    /***
     * Test exception path of getConnection on the blocking connection factory
     */
    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = "checkintest" , order = 1 )
    public void testGetBlockingConnectionConnectionRefused( )
        throws IOException
    {
        try
        {

            BlockingConnectionFactory factory = new BlockingConnectionFactory();
            IBlockingConnection connection = factory.getConnection( "localhost", 5001 );
            connection.close();
        }
        catch ( SocketClientException socketClientException )
        {
            socketClientException.printStackTrace();
        }
    }


    /***
     * Test getConnection on the blocking connection factory
     */
    @Test
    @Suite( groups = { "checkintest" } , order = 2 )
    public void testGetBlockingConnection( )
        throws IOException
    {
        // Create a socket server
        Server server = new Server( 5001, new IHandler()
        {
        } );
        ConnectionUtils.start( server );

        // Get a connection to the server using the factory
        BlockingConnectionFactory factory = new BlockingConnectionFactory();
        IBlockingConnection connection = factory.getConnection( "localhost", 5001 );
        Assert.assertNotNull( connection );
        connection.close();
        server.close();
    }


    /***
     * Test to check whether the setting of readTimeoutMillis is working
     */
    @Test( expected = SocketTimeoutException.class )
    @Suite( groups = { "checkintest" } , order = 3 )
    public void testBlockingConnectionResponseTimeOut( )
        throws IOException
    {

        byte EOB = 0x1C;

        Server server = new Server( 1605, new IHandler()
        {
        } );
        ConnectionUtils.start( server );

        BlockingConnectionFactory factory = new BlockingConnectionFactory();
        IBlockingConnection connection = factory.getConnection( "localhost", 1605 );
        connection.setReadTimeoutMillis( 1 );
        connection.readByteBufferByDelimiter( String.valueOf( ( char )EOB ) );
        connection.close();

        server.close();
    }

}
